~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/04/21 06:25                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-Apr-20 23:11                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     AIT_TLD_MCFL_CNL_011PUP.DLIS               :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_011PUP                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      2191.5120       :START DEPTH     
STOP .M      2302.4592       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        20-Apr-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AT10 .OHMM                                             :Array Induction Two Foot Resistivity A10 {F13.4}
AT20 .OHMM                                             :Array Induction Two Foot Resistivity A20 {F13.4}
AT30 .OHMM                                             :Array Induction Two Foot Resistivity A30 {F13.4}
AT60 .OHMM                                             :Array Induction Two Foot Resistivity A60 {F13.4}
AT90 .OHMM                                             :Array Induction Two Foot Resistivity A90 {F13.4}
ATCO90.MM/M                                            :Array Induction Two Foot Conductivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
DPHI_LIM.V/V                                           :Density Porosity (matrix Limestone) {F13.4}
DPHI_SAN.V/V                                           :Density Porosity (matrix Sandstone) {F13.4}
GDEV .DEG                                              :HGNS Deviation {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HTEM .DEGC                                             :HTC Temperature {F13.4}
NPOR_LIM.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
NPOR_SAN.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEFZ .                                                 :HRDD Standard Resolution Formation Photoelectric Factor {F13.4}
RHOZ .K/M3                                             :HRDD Standard Resolution Formation Density {F13.4}
RXOZ .OHMM                                             :MCFL Standard Resolution Invaded Zone Resistivity {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AT10         AT20         AT30         AT60         AT90        ATCO90        BS         DPHI_LIM     DPHI_SAN       GDEV         GR           HCAL         HDRA         HTEM       NPOR_LIM     NPOR_SAN       PEFZ         RHOZ         RXOZ         SP           TENS
#
~A  
 2191.5120      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.5727      79.0930     356.6926     147.1467      52.1810       0.1927       0.2446       4.6913    2557.4968       4.9392     -46.4375    4107.0000
 2191.6644      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.6571      79.0930     340.3032     147.1467      52.1810       0.1927       0.2446       4.6913    2557.4968       4.9392     -46.4375    4075.0000
 2191.8168      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.7146      76.4565     359.6974     147.1467      52.1810       0.2311       0.2842       4.6913    2557.4968       6.1267     -46.4375    4121.0000
 2191.9692      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.7845      72.8061     339.7569     147.1467      52.1810       0.1243       0.1725       4.6913    2557.4968      17.3855     -46.4375    4099.0000
 2192.1216      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.7301      75.4425     333.2011     147.1467      52.1810       0.0609       0.1038       4.6913    2557.4968      74.8680     -46.4375    4052.0000
 2192.2740      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.6910      77.7137     354.5074     147.1467      52.1810       0.0536       0.0951       4.6913    2557.4968      59.5645     -46.4375    4086.0000
 2192.4264      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.5407      80.3501     357.7852     147.1467      52.1810       0.0617       0.1041       4.6913    2557.4968      21.1521     -46.2500    4109.0000
 2192.5788      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1114       0.0791      20.4479      80.5529     358.3316     176.2877      52.1810       0.1100       0.1564       4.9613    2519.4280      10.1409     -46.4375    4124.0000
 2192.7312      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.1295       0.0978      20.3504      81.3238     370.3505     209.8255      52.1810       0.1245       0.1722       5.2066    2488.5835       6.0890     -46.3750    4062.0000
 2192.8836      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.0965       0.0637      20.4346      82.1350     381.8231     243.3984      52.1810       0.1093       0.1564       5.2268    2544.9045       6.6860     -46.4375    4100.0000
 2193.0360      92.0371      82.0592     273.6487    1900.1772    1950.0000       0.5004     311.0000       0.0647       0.0307      20.5464      87.0023     362.9753     256.7968      52.1810       0.1333       0.1822       5.1548    2599.3694       9.7376     -46.0000    4190.0000
 2193.1884      94.2755      82.7014     278.4036    1790.5233    1950.0000       0.5068     311.0000       0.0878       0.0547      20.6086      91.8695     374.7210     232.3570      52.1810       0.1350       0.1840       5.1886    2559.7783      15.7886     -46.4375    4096.0000
 2193.3408      97.8085      84.7142     285.7916    1400.3160    1799.4807       0.5557     311.0000       0.1451       0.1140      20.5153      92.6807     384.5547     192.3497      52.1810       0.0756       0.1201       5.3498    2461.8848      11.4483     -46.4375    4048.0000
 2193.4932      98.8327      81.2884     286.2018     887.0448    1402.6010       0.7130     311.0000       0.1969       0.1677      20.5489      86.5967     390.0178     153.5528      52.1810       0.0833       0.1284       5.5515    2373.3333       7.5739     -46.4375    4102.0000
 2193.6456      99.7620      80.3767     252.1321     517.9333     938.9014       1.0651     311.0000       0.2155       0.1870      20.4761      83.0431     384.5547     132.3793      52.1810       0.1502       0.1996       5.6324    2341.4968       6.4104     -45.8125    4315.0000
 2193.7980      99.7343      83.0655     200.6758     305.0543     580.3655       1.7231     311.0000       0.2177       0.1893      20.4967      82.2319     384.5547     125.2341      52.1810       0.1430       0.1922       5.5922    2337.7175       5.6253     -45.1250    4217.0000
 2193.9504      94.7977      88.4767     152.4924     192.4666     362.0392       2.7621     311.0000       0.1729       0.1428      20.3051      80.4066     384.5547     155.4251      52.1810       0.0995       0.1462       5.4135    2414.3381       6.7726     -45.6250    4087.0000
 2194.1028      82.7039      78.3135     115.9511     139.2286     245.8457       4.0676     311.0000       0.1274       0.0957      20.3603      73.4145     388.3789     184.7942      52.1810       0.1274       0.1761       5.2206    2492.0815       8.6612     -46.4375    4129.0000
 2194.2552      79.3041      80.5295      95.3272      88.0751     169.7854       5.8898     311.0000       0.0857       0.0525      20.4336      74.0229     392.7494     205.9026      52.1810       0.1219       0.1701       5.0545    2563.4543      10.7809     -46.5000    4101.0000
 2194.4076      64.7114      88.0788      90.6934      82.9146     117.7902       8.4897     311.0000       0.0817       0.0483      20.4911      77.4706     397.1199     201.5972      52.1810       0.0991       0.1455       5.0003    2570.2942      10.4245     -47.6875    4031.0000
 2194.5600      76.0428     132.2193     155.6673     129.3241     202.5963       4.9359     311.0000       0.0889       0.0558      20.5779      79.7014     365.1605     210.9196      52.1810       0.0835       0.1290       5.0264    2557.9539      12.8002     -48.3750    3922.0000
 2194.7124      76.9389     202.3307     289.9813     153.2382     232.5620       4.2999     311.0000       0.1181       0.0861      20.5977      73.0089     368.1653     225.6577      52.1810       0.1288       0.1774       5.1510    2507.9785      11.5552     -48.1875    3787.0000
 2194.8648     148.4057     289.3632     967.9980     450.6928     485.5479       2.0595     311.0000       0.1433       0.1122      20.5837      73.4145     366.5263     239.8520      52.1810       0.1488       0.1986       5.2620    2464.9521       9.0974     -47.7500    3659.0000
 2195.0172     151.5685     199.3870     955.4921     476.4871     797.2490       1.2543     311.0000       0.1271       0.0954      20.2775      78.6874     361.0632     258.4145      52.1810       0.1367       0.1860       5.2664    2492.6316       8.1342     -47.8750    3530.0000
 2195.1696     147.9799     147.6606     584.1171     394.5709     304.2281       3.2870     311.0000       0.1186       0.0865      20.2509      87.6107     378.5452     248.4651      52.1810       0.1192       0.1677       5.2147    2507.2793       8.9323     -56.1875    5532.0000
 2195.3220     146.8401     144.0565     656.3593     353.6279     455.8332       2.1938     311.0000       0.1005       0.0678      20.1532      92.0723     373.3552     239.8593      52.1810       0.1480       0.1980       5.1157    2538.1282       7.9489     -56.1875    5373.0000
 2195.4744     127.2407     126.5577     454.1954     226.4429     408.3829       2.4487     311.0000       0.1216       0.0897      20.1908      93.1821     372.5358     202.1568      52.1810       0.1733       0.2245       5.0640    2502.0771       8.0959     -47.3125    5292.0000
 2195.6268     161.4567     175.4071    1128.5349     394.9641    1236.6605       0.8086     311.0000       0.0957       0.0629      20.4608      92.3709     355.0537     181.2744      52.1810       0.1589       0.2095       4.9070    2546.2944       6.8781     -53.5000    5159.0000
 2195.7792     131.3791     166.6427     277.0318     166.6614     355.3555       2.8141     311.0000       0.0618       0.0277      20.4515      82.6364     356.1463     154.4540      52.1810       0.1460       0.1957       4.7067    2604.2515      10.3552     -56.1875    5029.0000
 2195.9316      97.2183     106.4385     115.5358      62.5690     113.5517       8.8066     311.0000       0.0542       0.0198      20.4961      78.4846     343.0348     125.7093      52.1810       0.0893       0.1354       4.5714    2617.2729      12.5014     -46.4375    4919.0000
 2196.0840      46.0654      55.5153      62.5013      41.9849      79.5994      12.5629     311.0000       0.0962       0.0634      20.2905      72.8061     337.5716     104.3751      52.1810       0.0993       0.1455       4.6427    2545.4346      10.4847     -61.2500    4771.0000
 2196.2364      22.7937      28.8434      36.8592      26.6000      37.3041      26.8067     311.0000       0.1634       0.1330      20.2727      70.3725     346.3127      95.7196      52.1810       0.0976       0.1433       4.8970    2430.6006       6.3757     -56.1875    4674.0000
 2196.3888      32.5146      43.6535      56.1565      29.1293      40.6351      24.6093     311.0000       0.1824       0.1527      20.2258      62.8688     338.1179     113.3902      52.1810       0.0889       0.1341       5.1575    2398.0310       4.5772     -56.1875    4607.0000
 2196.5412      55.3204      63.3165     126.2846      83.0439      61.9229      16.1491     311.0000       0.1952       0.1659      20.4019      54.1951     334.8401     130.0797      52.1810       0.0778       0.1225       5.4074    2376.2363       5.2519     -56.1875    4457.0000
 2196.6936      44.3592      64.4414     124.4846     168.8385      50.7816      19.6922     311.0000       0.2270       0.1989      20.5343      53.3839     335.9327     155.2796      52.1810       0.0977       0.1438       5.6889    2321.8777       5.0044     -56.1875    4324.0000
 2196.8460      44.4833      51.5031      88.8060     106.0305      36.0312      27.7537     311.0000       0.2716       0.2451      20.4520      55.4119     338.1179     180.9194      52.1810       0.1257       0.1734       5.9339    2245.5383       4.5446     -56.1875    4282.0000
 2196.9984      80.4987      83.5436     162.9609     138.9875      36.4203      27.4572     311.0000       0.1837       0.1540      20.3509      62.8688     347.9516     249.2616      52.1810       0.1222       0.1694       5.7915    2395.8433       3.9590     -56.1875    4275.0000
 2197.1508     116.4382     103.1011     188.9213     135.2982      65.6102      15.2415     311.0000       0.0522       0.0178      20.0241      64.0856     348.7711     269.5169      52.1810       0.1213       0.1690       5.2683    2620.6853       6.0159     -56.6875    4246.0000
 2197.3032     141.4885     220.3659     780.7318     177.9183     163.3426       6.1221     311.0000      -0.0496      -0.0877      20.0559      61.6520     333.2011     256.4709      52.1810       0.1540       0.2041       4.6747    2794.7322      19.2413     -57.0625    4302.0000
 2197.4556     111.4549     226.5847     326.9213      91.9398     789.8602       1.2660     311.0000      -0.0496      -0.0878      19.9922      55.5679     336.4790     204.0942      52.1810       0.1260       0.1738       4.3971    2794.8289    1117.9996     -56.1875    4349.0000
 2197.6080     105.6261     127.8933     146.2479      51.5216     736.2217       1.3583     311.0000      -0.0279      -0.0652      19.9738      53.7427     349.5905     170.1021      52.1810       0.0456       0.0861       4.3955    2757.6345    1033.8730     -56.1875    4432.0000
 2197.7604      33.7597      63.4351      60.7971      41.6888     131.7640       7.5893     311.0000      -0.0204      -0.0575      20.1984      52.3699     369.8042     136.5838      52.1810       0.0411       0.0798       4.4154    2744.8518      24.5733     -56.1875    4397.0000
 2197.9128      37.4939      50.1844      45.2448      33.5369     167.3139       5.9768     311.0000       0.0065      -0.0297      20.3707      48.7194     379.0916      92.4957      52.1810       0.0661       0.1067       4.3566    2698.9700      22.1280     -55.7500    4334.0000
 2198.0652      69.7836      95.1076     109.6152      69.9345     117.4003       8.5179     311.0000       0.0203      -0.0153      20.5163      48.3138     368.7115      65.8007      52.1810       0.0566       0.0968       4.2353    2675.2852      14.1598     -55.8125    4341.0000
 2198.2176     105.9628     137.8368      92.5400      75.2780      80.0820      12.4872     311.0000       0.0106      -0.0254      20.5061      47.4558     327.4648      63.5040      52.1810       0.0594       0.1002       4.1075    2691.9331      32.8642     -54.8125    4239.0000
 2198.3700      78.1144      76.4883      77.0771      96.5138      52.9876      18.8723     311.0000       0.0177      -0.0180      20.3610      51.8381     313.2606      50.2517      52.1810       0.0643       0.1059       3.9801    2679.6763      28.0263     -52.8750    4281.0000
 2198.5224     105.3122     125.1926      69.3427      80.2601      41.9360      23.8459     311.0000       0.0430       0.0082      20.0318      51.8381     311.3485      27.7140      52.1810       0.0687       0.1108       3.8264    2636.3909      34.1397     -49.6250    4361.0000
 2198.6748     148.0992     121.5678     133.8181     125.0181      43.6169      22.9269     311.0000       0.0791       0.0456      19.9523      56.0782     307.5243       5.8789      52.1810       0.0663       0.1082       3.6804    2574.6782      19.2063     -46.6875    4379.0000
 2198.8272     205.1028     162.6210     270.9214     107.9381      50.2219      19.9116     311.0000       0.0947       0.0618      20.0654      55.5491     317.9043      28.8548      52.1810       0.0865       0.1305       3.8826    2547.9990      14.3486     -46.4375    4454.0000
 2198.9796     179.0603     188.2701     694.5526     117.2018      51.9810      19.2378     311.0000       0.1476       0.1166      20.0423      60.0108     327.1916      72.7732      52.1810       0.0616       0.1040       4.4570    2457.6162      11.2027     -46.4375    4360.0000
 2199.1320     171.0314     114.4508     718.3473      75.0890      45.2978      22.0761     311.0000       0.2211       0.1928      20.0200      68.9529     317.9043     130.9404      52.1810       0.0954       0.1414       5.2717    2331.9346       6.3615     -46.4375    4262.0000
 2199.2844     128.9269      62.5879     156.4385      64.3387      43.1988      23.1488     311.0000       0.2084       0.1796      19.9748      79.4986     331.5622     202.2300      52.1810       0.1954       0.2470       5.6460    2353.6965       5.1476     -46.3750    4223.0000
 2199.4368     158.5939      68.3623     147.7317      83.0247      71.9334      13.9018     311.0000       0.1050       0.0724      19.8820      82.7434     330.4695     236.0947      52.1810       0.2197       0.2725       5.4477    2530.4653       5.8228     -46.4375    4143.0000
 2199.5892     270.3928      76.2609     102.9284      71.5042      73.3670      13.6301     311.0000      -0.0227      -0.0598      19.7996      72.7558     328.5574     211.2017      52.1810       0.1620       0.2128       4.8103    2748.7388      13.8491     -46.2500    4236.0000
 2199.7416     125.2330      46.4487      74.0446      57.2045      64.9081      15.4064     311.0000      -0.0449      -0.0829      20.0348      66.8745     335.6595     111.2373      52.1810       0.1124       0.1604       4.1680    2786.7461      75.9930     -43.1250    4353.0000
 2199.8940      70.5157      38.7662      40.7088      42.9170      72.1964      13.8511     311.0000      -0.0099      -0.0466      20.6663      64.2172     361.6095      35.3014      52.1810       0.0865       0.1318       3.7475    2726.9031     322.8156     -39.5000    4519.0000
 2200.0464      61.9857      62.6358      52.7417      45.5287      49.0768      20.3762     311.0000       0.0507       0.0162      20.8048      62.4423     366.5263      12.3110      52.1810       0.0583       0.1002       3.8154    2623.2419     138.7074     -36.7500    4644.0000
 2200.1988      40.2263      73.1371      61.4955      54.1972      53.2323      18.7856     311.0000       0.1271       0.0954      20.8386      63.8620     390.0178      41.4131      52.1810       0.0650       0.1077       4.3451    2492.6560      18.3807     -36.8125    4566.0000
 2200.3512      65.6339     104.6857      95.1693      66.5589      64.5123      15.5009     311.0000       0.2347       0.2069      19.9609      68.3445     384.5547      77.6000      52.1810       0.1112       0.1585       5.2651    2308.6216       7.3645     -37.0625    4497.0000
 2200.5036      98.0412     195.4545     156.7267     139.2628      58.2336      17.1722     311.0000       0.3437       0.3198      19.7986      77.7710     344.6737     119.5807      52.1810       0.1984       0.2506       6.1970    2122.2524       3.5091     -37.1250    4412.0000
 2200.6560      87.5411      96.1551     114.5531      84.9053      47.1245      21.2204     311.0000       0.4448       0.4246      19.7319      82.2326     346.8590     129.6643      52.1810       0.2616       0.3149       6.9576    1949.4524       2.3072     -37.8125    4229.0000
 2200.8084     129.7880      27.1063      36.5890      85.9213      21.4689      46.5789     311.0000       0.4687       0.4493      19.7078      76.5542     356.6926     122.2683      52.1810       0.2774       0.3303       7.1791    1908.5872       1.9152     -38.3125    4258.0000
 2200.9608     174.0455      38.4890      57.7589      46.0525      22.5410      44.3636     311.0000       0.3991       0.3773      19.6064      71.9949     374.1747      99.0109      52.1810       0.2460       0.2982       6.7635    2027.4768       2.0331     -39.6875    4294.0000
 2201.1132     199.7227     108.5912     127.3738     145.9023      43.7821      22.8404     311.0000       0.2346       0.2068      19.6965      65.3024     355.6000      94.5673      52.1810       0.1866       0.2381       5.8624    2308.7551       3.1546     -39.9375    4320.0000
 2201.2656     485.2479      95.7097     301.5056     227.2278      78.3350      12.7657     311.0000       0.0733       0.0396      19.5945      63.8644     364.8874     101.8090      52.1810       0.1273       0.1758       4.9738    2584.6140       7.4008     -39.0625    4385.0000
 2201.4180     178.9822      95.9214     898.3962     416.8456     220.2652       4.5400     311.0000      -0.0372      -0.0749      19.7622      57.5775     358.8779     106.5192      52.1810       0.0686       0.1111       4.3868    2773.5632      57.1699     -37.5000    4386.0000
 2201.5704      81.5474      71.8595     146.7510     361.3911     111.9559       8.9321     311.0000      -0.0724      -0.1113      19.7276      50.6823     377.4526      95.4337      52.1810       0.0384       0.0762       4.1302    2833.7273     253.6777     -36.6875    4368.0000
 2201.7228      44.2509      44.0996      95.6648      79.1799      43.2510      23.1208     311.0000      -0.0581      -0.0965      19.8543      47.2530     320.0895      82.9585      52.1810       0.0434       0.0821       4.1561    2809.2900     527.5356     -36.6875    4336.0000
 2201.8752      32.7051      31.9073      64.1705      85.2024      50.0641      19.9744     311.0000      -0.0205      -0.0576      19.9231      47.8614     323.3674     103.0672      52.1810       0.0460       0.0851       4.4510    2745.0178     622.6295     -36.6875    4250.0000
 2202.0276      29.7131      28.5649      60.8614      65.0018      54.4272      18.3732     311.0000       0.0274      -0.0080      19.9140      62.8688     322.8211     149.0715      52.1810       0.0514       0.0921       4.9130    2663.1643      49.5412     -36.3125    4239.0000
 2202.1800      22.7580      22.2740      42.2886      49.2319      39.3959      25.3833     311.0000       0.1012       0.0685      19.9169      72.4005     325.0064     177.7642      52.1810       0.0870       0.1321       5.3830    2536.9690      10.5995     -34.9375    4290.0000
 2202.3324      17.5465      18.4800      30.2148      27.5932      25.2239      39.6450     311.0000       0.1778       0.1479      19.6209      83.9603     340.0300     177.7670      52.1810       0.1451       0.1951       5.6950    2405.8835       5.6853     -35.3125    4261.0000
 2202.4848      22.6888      23.5940      35.8342      26.7965      29.2309      34.2104     311.0000       0.2286       0.2005      19.6733      78.2818     342.4884     167.8712      52.1810       0.3270       0.3791       5.8575    2319.1113       4.3737     -36.3750    4347.0000
 2202.6372      31.7918      37.2579      69.4657      53.1328      76.4359      13.0829     311.0000       0.2358       0.2080      19.6205      80.3098     386.7400     187.7749      52.1810       0.3353       0.3861       5.9654    2306.7769       4.3425     -36.6875    4370.0000
 2202.7896      50.4855      54.8136     187.7212     107.8583     139.1693       7.1855     311.0000       0.2617       0.2348      19.8556      79.2958     423.8894     195.0171      52.1810       0.2497       0.3011       6.1269    2262.5454       4.5815     -37.2500    4451.0000
 2202.9420      63.3277      97.7333     335.2943     196.6187     276.2821       3.6195     311.0000       0.3153       0.2904      19.9208      79.0767     406.9536     186.2867      52.1810       0.2230       0.2741       6.3762    2170.8752       3.8234     -38.6875    4409.0000
 2203.0944      46.8415      81.5619     406.5945     799.0414    1080.9203       0.9251     311.0000       0.3565       0.3331      19.7956      75.1007     418.9725     188.0870      52.1810       0.2307       0.2824       6.6642    2100.3574       3.1828     -39.3750    4377.0000
 2203.2468      50.4396      50.0740     158.4959     231.3090     320.7763       3.1174     311.0000       0.3997       0.3779      19.8552      75.8859     375.2673     194.7318      52.1810       0.2137       0.2650       7.0269    2026.4978       2.4900     -40.9375    4321.0000
 2203.3992      26.6941      28.3399      89.7179     246.5318     355.4774       2.8131     311.0000       0.4170       0.3958      19.7666      79.5526     376.9063     192.2371      52.1810       0.2426       0.2935       7.2240    1996.9913       2.1812     -42.6250    4236.0000
 2203.5516      28.4774      27.9284      83.6119     193.4935     302.9952       3.3004     311.0000       0.3501       0.3265      19.7933      74.1998     382.3694     180.5364      52.1810       0.2967       0.3500       6.9226    2111.2964       2.0743     -45.0000    4207.0000
 2203.7040      55.7970      44.4880     134.6176     165.2189     195.6658       5.1108     311.0000       0.1999       0.1708      19.6691      72.4005     373.0821     149.5948      52.1810       0.1801       0.2305       6.0543    2368.2534       2.9713     -46.4375    4335.0000
 2203.8564      62.0035      55.1114     213.7692     158.7913     182.1128       5.4911     311.0000       0.0499       0.0154      19.6429      69.2236     323.3674     108.2113      52.1810       0.0206       0.0591       5.0425    2624.6643       7.2542     -46.2500    4393.0000
 2204.0088      49.0048      59.1167     567.1790      82.8681     138.0632       7.2431     311.0000       0.0391       0.0041      19.6413      75.1048     323.3674      41.1086      52.1810       0.0198       0.0581       4.3394    2643.2241      31.5497     -44.6875    4516.0000
 2204.1612      42.9011      64.0374     125.8454      76.6301      49.1327      20.3531     311.0000       0.1420       0.1108      19.4828      76.2456     323.3674       8.1546      52.1810       0.1410       0.1901       4.3287    2467.1260      14.5187     -43.3750    4528.0000
 2204.3136      31.0635      84.3616     120.8674      86.7436      49.8587      20.0567     311.0000       0.2875       0.2616      19.5945      77.5973     314.0800      20.3555      52.1810       0.1593       0.2090       4.9429    2218.3193       5.6809     -44.4375    4466.0000
 2204.4660      28.4584      41.2402      79.0210      60.9469      31.6568      31.5888     311.0000       0.3710       0.3481      19.6837      82.9400     335.9327      81.0765      52.1810       0.0904       0.1351       5.7871    2075.6147       3.3590     -44.6250    4331.0000
 2204.6184      22.2351      28.0305      36.7253      45.0744      17.3420      57.6633     311.0000       0.3775       0.3549      19.8634      78.9600     369.5311     147.1777      52.1810       0.0666       0.1092       6.3113    2064.4087       2.5202     -45.3750    4327.0000
 2204.7708      44.0766      39.0834      50.3495      42.4529      23.7904      42.0337     311.0000       0.3359       0.3118      19.8922      82.9090     384.0084     183.5440      52.1810       0.0877       0.1319       6.3096    2135.5513       2.5445     -46.4375    4248.0000
 2204.9232      56.5882      63.3237      85.0143      66.7313      31.7523      31.4938     311.0000       0.2734       0.2470      19.8500      77.5663     412.4167     185.6706      52.1810       0.0889       0.1320       5.9734    2242.5283       2.9890     -48.1875    4339.0000
 2205.0756      82.0159     104.4006     246.6240     114.6858      46.9895      21.2813     311.0000       0.2200       0.1916      19.9059      83.4303     426.6209     169.3742      52.1810       0.0630       0.1039       5.5642    2333.8115       4.5543     -53.0000    4313.0000
 2205.2280     142.4708     151.3232     568.1423     290.3788      95.2616      10.4974     311.0000       0.1720       0.1418      19.6272      78.2644     411.3241     171.3073      52.1810       0.0878       0.1332       5.2522    2415.9524       7.1051     -56.1875    4358.0000
 2205.3804     112.2779     149.2995     357.3086     283.4675     121.7327       8.2147     311.0000       0.1671       0.1368      19.5278      82.6490     404.4952     183.1067      52.1810       0.1531       0.2034       5.2180    2424.2502       8.2530     -57.0625    4296.0000
 2205.5328      65.0677      94.9590     241.0086     241.6510     133.2742       7.5033     311.0000       0.1885       0.1590      19.3045      78.6103     393.8420     191.6878      52.1810       0.2175       0.2698       5.3628    2387.7046       6.9184     -59.5000    4264.0000
 2205.6852      56.0266      76.8658     196.1147     246.5274     170.6609       5.8596     311.0000       0.1953       0.1660      19.2786      79.8665     388.1057     205.6117      52.1810       0.1786       0.2298       5.5360    2376.0625       5.4822     -62.8750    4256.0000
 2205.8376      44.2856      61.3289     160.5683     217.2768     176.4196       5.6683     311.0000       0.1929       0.1635      19.3840      79.9437     385.1010     203.6476      52.1810       0.1605       0.2107       5.6192    2380.1931       6.2099     -66.0000    4335.0000
 2205.9900      37.4338      46.5281     110.6557     179.6263     128.9938       7.7523     311.0000       0.1920       0.1626      19.7015      84.1830     368.1653     194.7968      52.1810       0.1145       0.1624       5.6087    2381.6985       6.3807     -66.0000    4328.0000
 2206.1424      30.7436      42.0142      84.5635      91.5732      85.0618      11.7562     311.0000       0.2248       0.1966      19.7948      85.5742     404.2220     164.5353      52.1810       0.1149       0.1632       5.5884    2325.6411       6.2309     -68.1250    4409.0000
 2206.2948      35.5932      53.2622     137.3750     343.7426     298.9856       3.3446     311.0000       0.2307       0.2027      19.8470      83.9518     364.8874     149.4858      52.1810       0.1921       0.2433       5.5385    2315.5276       4.5819     -70.1875    4429.0000
 2206.4472      39.2859      59.7740     191.8514     248.4327     253.7050       3.9416     311.0000       0.1984       0.1692      19.7510      81.4040     377.4526     152.8714      52.1810       0.2237       0.2752       5.4279    2370.8147       4.7458     -70.6250    4436.0000
 2206.5996      42.5836      64.5354     198.3218     281.0139     306.2372       3.2654     311.0000       0.1517       0.1208      19.7259      87.0714     396.0273     168.5965      52.1810       0.2124       0.2639       5.3036    2450.6238       5.8108     -71.6250    4391.0000
 2206.7520      48.3679      80.9346     230.8707     263.3353     313.4783       3.1900     311.0000       0.1278       0.0961      19.7478      91.1980     408.0462     190.6533      52.1810       0.2200       0.2720       5.2779    2491.4067       7.9843     -71.8750    4356.0000
 2206.9044      49.7087      93.4668     216.3417     188.5737     236.6713       4.2253     311.0000       0.1339       0.1024      19.5872      93.7653     410.7778     217.0522      52.1810       0.1971       0.2486       5.4713    2481.0991      10.2693     -73.0625    4332.0000
 2207.0568      63.3800      87.4194     171.5222     126.3264     159.5582       6.2673     311.0000       0.1826       0.1529      19.5860      87.8368     412.4167     207.2482      52.1810       0.1951       0.2463       5.7795    2397.6995       7.1755     -75.6875    4359.0000
 2207.2092      80.5031     199.4365     141.4629      94.2682     115.7327       8.6406     311.0000       0.1810       0.1512      19.2787      78.4374     400.3978     198.5309      52.1810       0.1735       0.2247       6.0129    2400.4888       5.9570     -75.7500    4393.0000
 2207.3616      57.8739     149.4415     102.6836      78.8831      87.2508      11.4612     311.0000       0.1816       0.1518      18.7616      68.2469     342.4884     160.8818      52.1810       0.1044       0.1508       6.1142    2399.5491       5.0537     -77.2500    4340.0000
 2207.5140      49.6374     172.0575     105.7036      66.4781      72.8153      13.7334     311.0000       0.1669       0.1366      18.7154      57.7484     330.4695     144.8638      52.1810       0.0490       0.0877       6.2041    2424.6257       6.4825     -79.1875    4345.0000
 2207.6664      45.0688     144.1778     125.0628      66.5939      62.6518      15.9612     311.0000       0.1885       0.1590      18.8239      49.5113     343.5811     110.1594      52.1810       0.0220       0.0560       6.3049    2387.6887       5.2708     -80.5000    4269.0000
 2207.8188      61.5583     244.0681     137.2516      70.5658      57.0870      17.5171     311.0000       0.2067       0.1779      19.6532      43.7146     358.8779      68.3176      52.1810       0.0248       0.0582       6.3116    2356.4719       4.4458     -82.0000    4242.0000
 2207.9712      81.6586     589.8311     228.5027      85.1764      54.8209      18.2412     311.0000       0.1922       0.1629      19.5985      39.4558     332.1085      37.7161      52.1810       0.0319       0.0663       6.2769    2381.2944       3.8659     -83.0000    4246.0000
 2208.1236     130.6628    1635.7687     398.3063      88.9294      51.7336      19.3298     311.0000       0.1931       0.1637      19.5769      41.0771     332.1085       9.0883      52.1810       0.0337       0.0687       6.1248    2379.8325       3.9743     -82.9375    4246.0000
 2208.2760     165.1607    1926.5049     480.5695      88.0164      51.8994      19.2680     311.0000       0.1747       0.1447      19.5627      41.8540     331.5622      12.2445      52.1810       0.0365       0.0729       5.8848    2411.2593       4.6153     -81.2500    4379.0000
 2208.4284     137.7777     202.6071     185.2363     100.6967      56.1305      17.8156     311.0000       0.1606       0.1301      19.6238      49.4527     340.8495      16.2785      52.1810       0.0374       0.0742       5.4702    2435.4004       5.6084     -77.4375    4432.0000
 2208.5808      92.3394     127.5760     135.8708      83.0087      57.8639      17.2819     311.0000       0.1515       0.1206      19.6366      52.0125     339.7569      17.8452      52.1810       0.0523       0.0900       5.1133    2450.9534       6.4127     -75.7500    4499.0000
 2208.7332      80.1919      87.9747     135.5332      93.2819      66.6120      15.0123     311.0000       0.1496       0.1187      19.7128      52.6111     339.7569      12.2199      52.1810       0.0434       0.0787       4.8610    2454.2246       6.0464     -75.7500    4462.0000
 2208.8856      78.1953      61.3239     167.3146     134.3381      92.0940      10.8585     311.0000       0.1480       0.1171      19.6489      47.0404     339.2105      17.5650      52.1810       0.0109       0.0421       4.7765    2456.8435       7.8579     -75.1250    4320.0000
 2209.0380      75.5660      73.5911     221.3801     207.6051     127.5065       7.8427     311.0000       0.1357       0.1043      19.5569      39.8597     335.9327      51.6367      52.1810      -0.0000       0.0288       4.8915    2477.9746       9.5411     -74.7500    4358.0000
 2209.1904     100.0610      91.3721     323.9011     349.1865     168.5078       5.9344     311.0000       0.0864       0.0531      19.2257      37.8414     327.4648     105.1104      52.1810       0.0030       0.0315       5.0216    2562.3228      14.4562     -73.3750    4316.0000
 2209.3428      93.5240     103.4261     550.4569     642.2568     247.1505       4.0461     311.0000       0.0168      -0.0189      19.2026      38.7582     329.9232     136.7095      52.1810       0.0098       0.0390       4.9525    2681.1921      19.2465     -71.2500    4297.0000
 2209.4952     109.8956     148.7201    1722.2788    1745.1489     485.6100       2.0593     311.0000      -0.0279      -0.0653      19.1033      41.6800     322.2748     110.6889      52.1810       0.0135       0.0440       4.6000    2757.7117      54.2187     -69.1875    4351.0000
 2209.6476     110.2842     205.0279    1950.0000    1950.0000     435.6013       2.2957     311.0000      -0.0327      -0.0702      19.1239      45.1051     328.8306      59.8395      52.1810       0.0133       0.0452       4.2424    2765.8562     448.3646     -66.0000    4312.0000
 2209.8000     101.6001     244.9764    1950.0000    1950.0000     383.3191       2.6088     311.0000      -0.0165      -0.0534      19.3737      47.2304     331.0158      19.0504      52.1810       0.0302       0.0650       4.0344    2738.1436    1556.4904     -65.7500    4384.0000
 2209.9524      87.7787     223.1834    1950.0000    1849.9342     478.9240       2.0880     311.0000      -0.0019      -0.0384      19.4357      51.4774     332.1085       3.5026      52.1810       0.0461       0.0824       4.0363    2713.2883    1646.8405     -60.4375    4420.0000
 2210.1048      67.7015     165.3156     492.2441     220.5601     328.9465       3.0400     311.0000      -0.0029      -0.0394      19.4254      51.7027     332.6548       5.9993      52.1810       0.0295       0.0639       4.0850    2714.9382    1850.7836     -58.9375    4355.0000
 2210.2572      61.3109     114.1466     229.4424     115.7064     185.3717       5.3946     311.0000      -0.0043      -0.0408      19.2548      52.1446     332.6548       6.4418      52.1810       0.0279       0.0617       4.0773    2717.3733    1705.8090     -56.1875    4325.0000
 2210.4096      45.4555      71.4727     165.1378      68.9953     142.9063       6.9976     311.0000      -0.0162      -0.0532      19.1376      50.3313     331.5622       8.1739      52.1810       0.0318       0.0658       3.9642    2737.7290    1291.8484     -56.1875    4276.0000
 2210.5620      43.0792      56.0147     110.0298      67.3622      98.4805      10.1543     311.0000      -0.0104      -0.0472      19.0346      55.4160     329.9232       4.4680      52.1810       0.0198       0.0525       3.8828    2727.8186    1036.4834     -53.9375    4263.0000
 2210.7144      37.1758      59.3522     130.6061     101.4823      95.7755      10.4411     311.0000      -0.0100      -0.0467      18.9948      55.9882     330.4695       3.9787      52.1810       0.0156       0.0479       3.8148    2727.0408     929.2050     -47.8125    4327.0000
 2210.8668      37.8831      61.6298     161.9474     104.7248      72.3837      13.8153     311.0000      -0.0001      -0.0364      19.0889      52.9514     330.4695       3.5059      52.1810       0.0178       0.0509       3.8144    2710.0989    1006.2610     -45.8125    4356.0000
 2211.0192      38.0002      61.6550     116.4149     106.3145      49.6490      20.1414     311.0000       0.0271      -0.0083      19.1122      49.0834     330.4695      24.0967      52.1810       0.0253       0.0600       4.1569    2663.6467    1226.3033     -38.4375    4410.0000
 2211.1716      39.1156      65.1213     167.2297     178.5757      34.7373      28.7875     311.0000       0.0832       0.0498      19.1897      57.2935     336.4790      66.8321      52.1810       0.0323       0.0678       4.7945    2567.7952      40.1878     -36.6875    4416.0000
 2211.3240      45.5310      84.7950     217.2883     229.4828      59.7122      16.7470     311.0000       0.1065       0.0740      19.1889      84.8857     329.6501     146.0221      52.1810       0.0397       0.0765       5.5555    2527.9604      13.8403     -32.8125    4451.0000
 2211.4764      60.0432     126.0766     277.9230     278.0145     126.3614       7.9138     311.0000       0.0973       0.0645      19.0410      98.4734     335.9327     209.9032      52.1810       0.0851       0.1259       6.0478    2543.5935      10.1804     -30.1875    4362.0000
 2211.6288      71.3607     277.9260    1010.4979     673.3290     208.9328       4.7862     311.0000       0.0709       0.0371      19.0964     102.8372     333.7474     241.2262      52.1810       0.0935       0.1354       6.3593    2588.7102      11.0028     -28.7500    4371.0000
 2211.7812      67.5332     246.6106     233.1912     160.7877     175.9946       5.6820     311.0000       0.0749       0.0413      19.0320      83.1061     352.3221     225.5099      52.1810       0.0312       0.0649       6.5495    2581.8430      10.7232     -26.9375    4355.0000
 2211.9336      40.7875     155.2907     207.3146     236.0007     153.3357       6.5216     311.0000       0.1098       0.0774      18.8945      72.7632     357.2390     184.6704      52.1810      -0.0096       0.0172       6.6404    2522.2690       6.9903     -24.8125    4362.0000
 2212.0860      43.7709     113.8150     176.4821     183.1993     190.4411       5.2510     311.0000       0.1522       0.1214      18.9426      56.1393     358.3316     152.0841      52.1810      -0.0203       0.0036       6.6306    2449.7026       5.8430     -20.5625    4341.0000
 2212.2384      36.0827      75.0703     121.1091     115.3910     132.8358       7.5281     311.0000       0.1767       0.1468      18.8560      48.9591     365.9800     134.8891      52.1810      -0.0145       0.0102       6.5037    2407.7849       5.0122     -17.1250    4311.0000
 2212.3908      32.8413      61.6184      94.5898     108.0888     129.8186       7.7031     311.0000       0.1338       0.1023      18.9220      47.7422     383.4621     153.5287      52.1810      -0.0067       0.0201       6.2212    2481.2009       6.3202     -15.3125    4297.0000
 2212.5432      32.9436      54.7448      80.3107      92.4198     125.7557       7.9519     311.0000       0.0960       0.0632      18.8925      58.1763     361.0632     169.5724      52.1810       0.0146       0.0457       5.9148    2545.7913       9.3157     -10.5000    4252.0000
 2212.6956      27.6946      37.0748      68.9977      71.4861     113.0303       8.8472     311.0000       0.1033       0.0707      19.1179      81.4208     341.9421     176.9440      52.1810       0.0264       0.0611       5.7194    2533.3054      12.3457      -6.2500    4373.0000
 2212.8480      28.8060      33.9153      49.2426      53.6526      86.4778      11.5637     311.0000       0.1441       0.1130      19.1362      93.9152     385.1010     178.8361      52.1810       0.0623       0.1017       5.6735    2463.6121       8.0240      -2.1250    4465.0000
 2213.0004      40.6274      33.7184      41.0315      40.4004      65.9834      15.1553     311.0000       0.1557       0.1250      19.0606     105.5808     404.2220     187.7768      52.1810       0.0960       0.1407       5.6428    2443.7939       6.6509      -0.4375    4579.0000
 2213.1528      42.6802      35.9659      40.2520      39.2449      70.1912      14.2468     311.0000       0.1561       0.1254      18.9704     101.5248     437.0009     196.8920      52.1810       0.1602       0.2105       5.6366    2443.0469       8.2211      -0.6875    4625.0000
 2213.3052      50.5951      45.3574      44.3369      40.1574      93.4438      10.7016     311.0000       0.2136       0.1850      18.7267     110.7896     447.9272     172.4391      52.1810       0.1937       0.2457       5.7433    2344.6870       7.2503      -0.4375    4536.0000
 2213.4576      86.1508      73.8913      64.7413      59.0295      94.8099      10.5474     311.0000       0.2543       0.2271      18.7527     104.5027     458.3072     155.6802      52.1810       0.1749       0.2262       5.8937    2275.2317       4.9668      -0.4375    4432.0000
 2213.6100     140.1102     114.8202     126.5834     101.4578     131.3600       7.6127     311.0000       0.2356       0.2078      18.9079      99.0090     414.6020     162.0925      52.1810       0.1568       0.2072       5.9414    2307.1377       4.0468      -0.6250    4319.0000
 2213.7624     123.9394     156.3055     106.4020      90.9336     114.6869       8.7194     311.0000       0.1741       0.1440      18.8763      91.1696     398.4857     194.2832      52.1810       0.1608       0.2114       5.8982    2412.3252       5.0925      -0.7500    4167.0000
 2213.9148     207.2044     222.6663     178.3583     146.4546     132.8824       7.5254     311.0000       0.1567       0.1261      19.0464      91.3438     414.6020     218.5798      52.1810       0.1680       0.2190       5.9348    2441.9910       5.8160      -0.8750    4184.0000
 2214.0672     636.7637     496.3048     385.9732     176.8968     101.7787       9.8252     311.0000       0.1469       0.1159      19.0921      89.4888     437.8204     250.2616      52.1810       0.1701       0.2212       6.0397    2458.8000       6.4143      -0.6875    4262.0000
 2214.2196     669.9725     451.4543    1051.9774     682.6548     146.3784       6.8316     311.0000       0.1841       0.1545      18.9649      81.8559     441.9178     235.5666      52.1810       0.1494       0.1996       6.1490    2395.1077       5.5641      -2.4375    4347.0000
 2214.3720     292.2541     161.5944     233.3783     279.0316     152.3026       6.5659     311.0000       0.1856       0.1560      18.9623      81.1402     462.6777     229.1765      52.1810       0.1625       0.2133       6.1663    2392.6570       4.6619      -4.8750    4602.0000
 2214.5244     141.6674      79.5568     200.8340     264.7017      87.7172      11.4003     311.0000       0.1838       0.1542      18.9289      81.7964     436.4546     203.1326      52.1810       0.1784       0.2298       6.0951    2395.6257       4.2410      -7.3750    4753.0000
 2214.6768     106.3575      60.0574      94.5366     274.2018      78.7167      12.7038     311.0000       0.1447       0.1135      18.9270      84.5601     395.4810     208.3030      52.1810       0.1322       0.1815       5.9497    2462.6460       5.2279      -7.3750    4661.0000
 2214.8292     230.1302      57.5272      92.4518     149.4109      75.6420      13.2202     311.0000       0.1181       0.0860      18.8924      84.8988     416.2410     215.1284      52.1810       0.1368       0.1862       5.8078    2508.0586       8.9774      -7.3750    4530.0000
 2214.9816     267.4863     100.0735     161.1640     209.5831     133.8682       7.4700     311.0000       0.1259       0.0941      18.9438      87.4581     437.2741     213.4213      52.1810       0.1227       0.1713       5.7447    2494.7610       8.1525      -7.3750    4412.0000
 2215.1340     418.2569     195.0482     302.2205     376.4655     248.8101       4.0191     311.0000       0.1104       0.0781      18.9130      94.4288     464.8629     227.6678      52.1810       0.1544       0.2048       5.7748    2521.1860       7.4124      -7.6250    4373.0000
 2215.2864     554.9082     213.1075    1046.1500    1135.0905     966.7161       1.0344     311.0000       0.0993       0.0665      19.0211      89.0211     461.0388     227.8740      52.1810       0.1674       0.2183       5.8077    2540.2036       7.0627      -8.5625    4285.0000
 2215.4388     392.6482     190.9979     685.2118     994.2678     662.3239       1.5098     311.0000       0.0927       0.0597      19.0616      94.5739     402.0368     231.8087      52.1810       0.2183       0.2705       5.8326    2551.5166       8.4292      -9.7500    4193.0000
 2215.5912     207.0286     146.6868     477.8870    1015.5246     507.7943       1.9693     311.0000       0.0915       0.0585      19.0011      86.8778     415.1483     231.9803      52.1810       0.2137       0.2654       5.7605    2553.5461       7.8293     -10.1875    4087.0000
 2215.7436     126.5595     101.0932     458.8185    1376.2098     532.1293       1.8792     311.0000       0.0934       0.0605      19.0548      92.2856     412.9631     223.2356      52.1810       0.2252       0.2773       5.6435    2550.2502       8.5119     -10.5625    3921.0000
 2215.8960      95.8331      86.9029     353.7410    1607.9225     461.1357       2.1686     311.0000       0.0708       0.0370      18.9775      87.9228     426.0746     218.1880      52.1810       0.2224       0.2748       5.5192    2588.9404       9.3526     -15.0000    4009.0000
 2216.0484      95.6785      84.9771     337.6304    1467.0597     651.8317       1.5341     311.0000       0.0465       0.0119      18.9125      93.3881     471.1456     217.2759      52.1810       0.1836       0.2351       5.4783    2630.4263      13.5595     -26.9375    4332.0000
 2216.2008      87.0432      72.3475     338.7823    1089.9899     697.5425       1.4336     311.0000       0.0158      -0.0200      18.8774      95.3656     475.2430     237.9084      52.1810       0.1549       0.2053       5.5171    2682.9470      17.2804     -30.0625    5008.0000
 2216.3532      72.0426      83.1037     256.0414     733.4678     752.5624       1.3288     311.0000       0.0220      -0.0135      19.0453      93.6443     442.7373     243.7978      52.1810       0.1608       0.2116       5.6371    2672.3540      17.5544     -28.3125    5366.0000
 2216.5056      75.4014      77.6421     183.1931     499.1937     721.0992       1.3868     311.0000       0.0409       0.0060      19.0683      86.3538     446.8346     230.5822      52.1810       0.1425       0.1923       5.7355    2640.0776      14.5383     -26.9375    5356.0000
 2216.6580      81.8844      62.2517     164.8624     360.2964     604.1987       1.6551     311.0000       0.0830       0.0497      19.1406      77.8866     466.5019     197.2969      52.1810       0.1280       0.1767       5.8127    2568.0459      13.5800     -27.6250    5187.0000
 2216.8104      51.4446      36.5733      78.9994     248.1996     489.5843       2.0425     311.0000       0.1183       0.0862      19.0543      70.5428     446.2883     174.2940      52.1810       0.1139       0.1615       5.8479    2507.7073      11.7491     -27.6250    5124.0000
 2216.9628      32.1230      31.1822      55.6040     170.3705     342.8654       2.9166     311.0000       0.1380       0.1066      19.1098      62.2175     428.8062     170.6855      52.1810       0.0993       0.1454       5.8574    2474.1025       8.7901     -27.3125    5001.0000
 2217.1152      33.9086      33.3540      61.7094     241.4282     342.7513       2.9176     311.0000       0.1292       0.0976      19.0880      66.3137     437.0009     173.5084      52.1810       0.0953       0.1410       5.8095    2489.0313       7.4226     -27.3125    4906.0000
 2217.2676      53.1679      54.3875      98.9762     301.8253     356.8313       2.8024     311.0000       0.0906       0.0575      18.9957      69.7879     429.3525     176.0838      52.1810       0.0855       0.1303       5.6789    2555.1062       7.7979     -27.3750    4810.0000
 2217.4200      92.4357     105.5102     209.5260     387.8479     331.8114       3.0138     311.0000       0.0636       0.0295      19.0095      74.2496     399.8515     176.6477      52.1810       0.1080       0.1549       5.5657    2601.2495       9.0178     -28.3125    4738.0000
 2217.5724     188.2014     161.7386     491.9041    1923.6713    1275.6611       0.7839     311.0000       0.0502       0.0157      19.1414      69.1485     408.0462     193.1641      52.1810       0.1118       0.1589       5.5413    2624.0886      12.6947     -28.1875    4519.0000
 2217.7248     189.9373     123.6855     252.7507     642.3327     242.0747       4.1310     311.0000       0.0503       0.0157      19.0799      66.5283     403.6757     218.7776      52.1810       0.0948       0.1410       5.5957    2624.0530      13.5015     -28.1250    4449.0000
 2217.8772     100.4268      76.4162     204.2208     178.7232     130.6237       7.6556     311.0000       0.0343      -0.0008      19.2363      62.4892     417.6068     245.4920      52.1810       0.1043       0.1509       5.6246    2651.3079      13.7037     -27.4375    4461.0000
 2218.0296      91.4498      37.4865      58.1355      94.4808      38.9614      25.6664     311.0000       0.0284      -0.0070      19.3479      64.1025     423.8894     249.4171      52.1810       0.1188       0.1660       5.6140    2661.5151      13.5777     -26.9375    4433.0000
 2218.1820      43.9300      42.3701      62.6903      53.6661      25.5561      39.1295     311.0000       0.0306      -0.0047      19.2792      63.9663     422.2504     238.6005      52.1810       0.0791       0.1233       5.5931    2657.6938      13.6972     -26.9375    4601.0000
 2218.3344      62.9533      84.3194     138.6841      72.2027      70.6848      14.1473     311.0000       0.0588       0.0245      19.1519      66.2825     415.6946     218.8499      52.1810       0.0785       0.1228       5.6394    2609.5144      11.7759     -26.6875    4602.0000
 2218.4868     116.8540     103.9381     236.7120     216.8508      98.6550      10.1363     311.0000       0.0756       0.0420      19.1534      69.3245     416.2410     220.0573      52.1810       0.1027       0.1492       5.7177    2580.6682      10.9596     -25.7500    4574.0000
 2218.6392     133.9213     128.8199     181.5180     203.5701     118.1278       8.4654     311.0000       0.1025       0.0699      19.1755      70.4839     421.7041     224.2429      52.1810       0.1292       0.1779       5.8100    2534.6465       9.6476     -25.6875    4435.0000
 2218.7916      93.0139      88.1905     164.0641     203.4392      65.2413      15.3277     311.0000       0.1177       0.0856      19.1199      75.6545     433.1767     219.0085      52.1810       0.1465       0.1963       5.8147    2508.8142       8.3329     -25.1875    4361.0000
 2218.9440      65.8623      61.7236     100.3860     218.4382      59.6980      16.7510     311.0000       0.1235       0.0916      19.2545      75.8388     424.4357     190.6164      52.1810       0.1364       0.1858       5.6925    2498.8904       7.5938     -24.1250    4393.0000
 2219.0964      46.9056      68.9227     107.5235     314.9289      63.8683      15.6572     311.0000       0.1203       0.0883      19.2209      76.8438     411.3241     161.2613      52.1810       0.1217       0.1703       5.5151    2504.2234       8.8011     -22.7500    4400.0000
 2219.2488      51.4779      60.4585     117.0066     319.2346      88.2884      11.3265     311.0000       0.1364       0.1050      19.2454      79.5784     403.1294     143.3816      52.1810       0.1557       0.2062       5.4338    2476.8062       9.6431     -21.4375    4435.0000
 2219.4012      55.8032      64.8400     141.7663     388.6938     115.7500       8.6393     311.0000       0.1503       0.1194      19.3172      78.1772     435.6351     144.2573      52.1810       0.1724       0.2236       5.4552    2453.0366       7.4448     -19.6875    4481.0000
 2219.5536      78.0287      86.5059     133.4093     344.0441     161.0067       6.2109     311.0000       0.1454       0.1143      19.3327      82.0121     415.1483     148.8369      52.1810       0.2063       0.2585       5.4600    2461.4028       7.4149     -18.6250    4489.0000
 2219.7060     106.7235      86.0453     116.8982     274.3478     200.3850       4.9904     311.0000       0.1161       0.0839      19.2751      82.7077     399.8515     144.4023      52.1810       0.2148       0.2672       5.3730    2511.4956       8.4013     -17.8125    4525.0000
 2219.8584      58.2411      52.6179      90.0979     207.0375     201.5782       4.9609     311.0000       0.1017       0.0691      19.2606      86.1553     418.9725     122.5679      52.1810       0.1825       0.2340       5.2848    2536.0579      11.2603     -17.7500    4397.0000
 2220.0108      49.6315      34.4679      51.1142     121.0028     138.2160       7.2351     311.0000       0.1117       0.0794      19.2832      89.1664     396.8468     112.9549      52.1810       0.1513       0.2014       5.3721    2519.0535       9.3907     -18.0000    4373.0000
 2220.1632      32.9208      32.9958      44.1701      93.2203     108.4982       9.2167     311.0000       0.1352       0.1038      19.2118      88.3725     402.0368     136.8151      52.1810       0.1711       0.2220       5.6473    2478.7322       9.3266     -17.4375    4437.0000
 2220.3156      47.8284      54.1276      77.0779     134.9352     135.8963       7.3586     311.0000       0.1458       0.1148      19.2847      81.7182     404.7683     196.7518      52.1810       0.1766       0.2278       5.9813    2460.6287       7.9852     -17.3125    4402.0000
 2220.4680      65.6044     116.9105     162.0004     154.5333     121.6983       8.2170     311.0000       0.1362       0.1048      19.3320      82.7816     412.9631     251.3363      52.1810       0.1989       0.2507       6.1518    2477.0295       7.8155     -17.1250    4403.0000
 2220.6204      85.4608     108.4450     114.8635     115.7761     134.2234       7.4503     311.0000       0.1450       0.1139      19.4166      86.3239     405.5878     256.6059      52.1810       0.2070       0.2590       6.1849    2462.0513       6.4178     -17.1250    4459.0000
 2220.7728     104.5016      92.0152      83.5759      93.6461      71.7962      13.9283     311.0000       0.1542       0.1235      19.4641      88.3138     411.3241     231.7288      52.1810       0.2136       0.2659       6.1328    2446.2969       6.0131     -17.7500    4460.0000
 2220.9252     122.5473     126.7134     121.1605     150.7290      90.5721      11.0409     311.0000       0.1746       0.1446      19.3609      88.9062     410.7778     194.6220      52.1810       0.1893       0.2411       6.1332    2411.3950       5.6238     -18.7500    4453.0000
 2221.0776     213.2969     145.6457     310.5574     108.0532      86.1049      11.6137     311.0000       0.1684       0.1382      19.2446      82.5246     403.1294     186.4829      52.1810       0.1474       0.1974       6.1405    2422.0400       4.8092     -19.6875    4486.0000
 2221.2300     139.5285     155.7261     404.1404     307.5008     135.9840       7.3538     311.0000       0.1663       0.1360      19.2513      89.0801     395.4810     191.4849      52.1810       0.1606       0.2111       6.1534    2425.6643       4.6133     -20.4375    4452.0000
 2221.3824     109.5093      85.1945     128.3149     116.1792      98.3995      10.1626     311.0000       0.1535       0.1227      19.0453      83.6205     405.8610     206.5747      52.1810       0.1990       0.2507       6.1140    2447.4939       4.0424     -21.7500    4476.0000
 2221.5348      76.6795      44.0556      79.5841      93.5387      95.0114      10.5251     311.0000       0.1416       0.1104      19.0348      91.8910     402.5831     210.0246      52.1810       0.2163       0.2683       6.0304    2467.8799       4.4111     -23.1250    4441.0000
 2221.6872      66.6611      29.4690      44.7154      56.7715      69.3843      14.4125     311.0000       0.1234       0.0915      19.1676      90.2027     421.1578     205.0548      52.1810       0.2207       0.2733       5.8918    2499.0564       4.8836     -23.5000    4397.0000
 2221.8396      79.9537      26.2424      37.2790      44.4897      53.3130      18.7571     311.0000       0.1020       0.0693      19.3980      94.0065     437.8204     197.4342      52.1810       0.1750       0.2260       5.7545    2535.6248       6.5394     -25.5625    4414.0000
 2221.9920      75.2961      39.2786      53.1275      71.0991      98.1000      10.1937     311.0000       0.0887       0.0555      19.3949      90.6033     422.7967     186.0819      52.1810       0.1901       0.2418       5.6299    2558.3848       8.7529     -26.9375    4386.0000
 2222.1444      74.6004      58.3213      85.8844     103.4927      98.8122      10.1202     311.0000       0.1074       0.0749      19.2873      84.2100     453.6635     165.2777      52.1810       0.1420       0.1918       5.5964    2526.3899       9.1098     -26.9375    4401.0000
 2222.2968      65.3875      99.6105     157.2003      85.7126     113.2459       8.8303     311.0000       0.1312       0.0996      19.2007      79.7977     439.7325     152.0147      52.1810       0.1652       0.2160       5.6151    2485.6594       7.1083     -26.9375    4365.0000
 2222.4492      62.6147     104.1957     422.0703      93.1588      72.8336      13.7299     311.0000       0.1526       0.1217      19.1015      75.9848     417.3336     146.5871      52.1810       0.1922       0.2438       5.6704    2449.1306       5.5310     -26.9375    4456.0000
 2222.6016      59.0740     113.7102     340.7154     218.0128      82.3860      12.1380     311.0000       0.1548       0.1240      19.0712      82.4770     423.8894     149.1630      52.1810       0.2141       0.2652       5.7296    2445.3237       5.4245     -26.8125    4482.0000
 2222.7540      51.8718      69.2621     183.6083     191.8825     112.3440       8.9012     311.0000       0.1681       0.1379      18.9716      86.3303     421.7041     144.4900      52.1810       0.2519       0.3036       5.8231    2422.5115       6.4266     -26.9375    4517.0000
 2222.9064      38.1903      36.2790      78.8999     123.1693      37.9489      26.3512     311.0000       0.1698       0.1396      19.1048      84.0141     419.2457     148.9768      52.1810       0.2445       0.2961       5.9216    2419.6841       5.7502     -26.9375    4541.0000
 2223.0588      52.4745      29.4363      60.4209     125.2794      36.4573      27.4293     311.0000       0.1646       0.1342      19.1574      87.3628     422.2504     160.7416      52.1810       0.2119       0.2637       6.0343    2428.5762       5.9605     -27.3125    4501.0000
 2223.2112      76.5916      36.8360      88.5501     212.2062      64.7448      15.4453     311.0000       0.1454       0.1143      19.2857      87.2589     424.7089     177.5339      52.1810       0.2430       0.2952       6.0996    2461.3301       6.0589     -27.5000    4404.0000
 2223.3636     108.1616      60.3230     145.2492     260.3937     105.6373       9.4664     311.0000       0.1170       0.0849      19.3399      87.9124     432.0841     205.7240      52.1810       0.2265       0.2794       6.1477    2509.8745       8.9690     -27.3125    4392.0000
 2223.5160     232.3349      79.7151     358.5366     827.1196     324.3398       3.0832     311.0000       0.0922       0.0592      19.2966      77.5831     441.9178     220.8130      52.1810       0.1016       0.1487       6.1232    2552.4011       9.3670     -26.9375    4378.0000
 2223.6684     138.3475      94.5313    1368.4152    1950.0000    1832.7515       0.5456     311.0000       0.0844       0.0511      19.1882      68.7637     370.3505     212.2629      52.1810       0.0592       0.1027       6.0471    2565.7563       9.8121     -25.2500    4426.0000
 2223.8208      68.3942      78.0856     210.7634     371.1431     535.8414       1.8662     311.0000       0.0919       0.0589      19.0158      71.1503     368.7115     187.5830      52.1810       0.1284       0.1771       5.9581    2552.7676       9.0601     -19.0000    4557.0000
 2223.9732      49.5733      57.0115      71.1250      82.5742     137.8806       7.2527     311.0000       0.1039       0.0713      18.8855      72.1506     376.9063     175.2312      52.1810       0.1830       0.2347       5.9422    2532.3743       9.3102     -17.1250    4559.0000
 2224.1256      47.6194      27.2088      43.3346      53.7116      99.9353      10.0065     311.0000       0.1261       0.0944      18.9665      79.7800     405.3146     172.0698      52.1810       0.1773       0.2286       6.0052    2494.3220       8.8882     -17.1250    4501.0000
 2224.2780      48.1894      18.0885      23.8509      29.8881      64.6865      15.4592     311.0000       0.1493       0.1184      19.0287      75.7710     414.6020     180.2349      52.1810       0.2066       0.2586       6.1483    2454.6589       8.2898     -16.2500    4513.0000
 2224.4304      37.6955      17.5191      20.4133      19.3215      35.4069      28.2431     311.0000       0.1977       0.1685      19.0754      75.9545     413.5093     175.4942      52.1810       0.2242       0.2763       6.3133    2371.9419       6.3146     -14.0000    4425.0000
 2224.5828      43.4415      30.0038      45.0615      35.1659     118.8425       8.4145     311.0000       0.2259       0.1977      19.1953      67.5139     375.8137     199.0793      52.1810       0.2085       0.2602       6.5322    2323.7856       5.2543     -11.3750    4361.0000
 2224.7352      90.7353      39.0756      87.7193      59.1085     144.9783       6.8976     311.0000       0.2811       0.2550      19.3100      69.4094     394.3884     196.1384      52.1810       0.1336       0.1828       6.7702    2229.2634       4.1565      -7.9375    4481.0000
 2224.8876     113.5511      47.2684     205.6051     138.0616     228.3055       4.3801     311.0000       0.2793       0.2531      19.2345      65.9810     385.6473     221.4215      52.1810       0.1623       0.2130       6.9170    2232.3237       3.5197      -7.0625    4528.0000
 2225.0400     105.1651      47.2816      87.5684      82.6481     181.5890       5.5069     311.0000       0.2593       0.2324      19.0617      62.8590     408.5926     248.8525      52.1810       0.2163       0.2688       6.9825    2266.5237       3.9722      -2.8125    4582.0000
 2225.1924     174.1928      64.9829      93.5423      91.9171     181.3016       5.5157     311.0000       0.2302       0.2022      18.7939      61.5719     417.3336     287.2002      52.1810       0.2283       0.2808       6.9698    2316.3430       4.4468      -0.1250    4544.0000
 2225.3448     160.0576      66.3284      79.0359      81.6285     142.0871       7.0379     311.0000       0.2403       0.2126      18.7027      68.2172     363.2484     305.1561      52.1810       0.2132       0.2639       7.0287    2299.1360       5.0171       1.3125    4416.0000
 2225.4972     150.8302      68.6314      93.1724      80.9442     141.0549       7.0894     311.0000       0.3012       0.2758      18.6240      77.8289     399.3052     263.0742      52.1810       0.2223       0.2737       7.0477    2194.9419       3.6053       2.0000    4447.0000
 2225.6496      67.8494      59.9919      44.7231      43.2847      64.0029      15.6243     311.0000       0.2985       0.2730      18.8249      79.8383     410.2315     236.7379      52.1810       0.2071       0.2586       6.8768    2199.5122       3.2569       2.3750    4451.0000
 2225.8020      86.2837      30.6893      22.6917      24.9332      34.1756      29.2607     311.0000       0.2593       0.2323      18.9222      75.6267     351.7758     208.8635      52.1810       0.3245       0.3762       6.5243    2266.6694       3.5067       2.3750    4380.0000
 2225.9544     146.2555      74.6800      58.6618      53.3306      87.3168      11.4526     311.0000       0.1583       0.1277      18.9475      72.2503     343.8542     220.8672      52.1810       0.2380       0.2902       6.1150    2439.3022       5.3160       2.3750    4408.0000
 2226.1068     225.5631     113.3966     103.1730      91.6477     156.8727       6.3746     311.0000       0.1153       0.0832      18.9616      69.4679     381.2768     212.8992      52.1810       0.1383       0.1876       5.8967    2512.7832       7.9332       2.3750    4424.0000
 2226.2592    1020.0480     511.6921     188.7146     176.1638     576.2772       1.7353     311.0000       0.1404       0.1091      19.0610      68.8595     438.6398     189.6517      52.1810       0.1408       0.1903       5.9119    2469.9504       8.7927       4.0625    4522.0000
 2226.4116     301.0318     241.8764     131.0673     128.9609     172.5765       5.7945     311.0000       0.1993       0.1702      18.9994      67.4698     457.2146     160.6643      52.1810       0.2347       0.2871       6.0570    2369.2068       7.5587       3.6250    4478.0000
 2226.5640     128.6635     124.1401      51.9759      51.8903      52.2916      19.1235     311.0000       0.2149       0.1864      18.9254      69.4596     479.3403     150.1865      52.1810       0.2415       0.2938       6.1390    2342.5171       6.3758       3.1250    4513.0000
 2226.7164      67.0782      41.1762      34.0358      34.4209      33.3846      29.9539     311.0000       0.2015       0.1724      18.8707      74.5408     469.2335     149.8928      52.1810       0.2099       0.2617       6.1352    2365.4771       6.4639       2.3750    4507.0000
 2226.8688      63.5816      23.7070      19.6470      19.9680      18.6589      53.5938     311.0000       0.2198       0.1914      18.7016      77.8872     461.5851     143.3833      52.1810       0.2696       0.3203       6.1872    2334.1084       5.5633       2.3750    4463.0000
 2227.0212      66.6119      17.0120      13.5033      13.5197      13.3858      74.7059     311.0000       0.2474       0.2201      18.6255      74.7148     474.4235     160.3124      52.1810       0.3345       0.3829       6.3632    2286.8867       4.5044       0.5000    4400.0000
 2227.1736      84.9504      38.2195      28.1221      29.8981      20.9602      47.7096     311.0000       0.2906       0.2648      18.8320      69.4308     371.4431     179.1050      52.1810       0.2727       0.3223       6.6412    2213.1492       4.0836      -2.5000    4487.0000
 2227.3260      99.9877      61.8535      60.8007      62.5846      49.1528      20.3447     311.0000       0.3170       0.2921      18.8629      69.1222     415.1483     200.8442      52.1810       0.1840       0.2342       6.8875    2167.9614       3.3970      -5.1250    4426.0000
 2227.4784     221.1704     287.2983     122.9538     178.5203      97.5951      10.2464     311.0000       0.3507       0.3271      18.9204      71.4834     438.6398     201.5458      52.1810       0.2206       0.2716       7.0271    2110.3462       2.8141      -6.8750    4466.0000
 2227.6308     103.9576     174.4286     112.3132     167.3174     115.2218       8.6789     311.0000       0.3520       0.3284      18.8572      75.3482     351.7758     209.6748      52.1810       0.2949       0.3447       7.0129    2108.0916       2.7533      -7.3750    4497.0000
 2227.7832      66.5434      69.5739      67.9847      92.0924      84.5403      11.8287     311.0000       0.3451       0.3213      18.6893      77.0764     369.8042     200.5234      52.1810       0.2583       0.3083       6.8800    2119.8469       2.6641      -9.8125    4542.0000
 2227.9356      24.2569      25.8103      26.1129      34.6827      32.1484      31.1058     311.0000       0.3186       0.2938      18.7316      74.5066     419.5189     175.0305      52.1810       0.2523       0.3045       6.6394    2165.2485       2.7711     -14.2500    4536.0000
 2228.0880      21.9702      12.7830      13.5587      24.6606      28.3965      35.2156     311.0000       0.2875       0.2616      18.6709      72.8853     462.6777     144.9048      52.1810       0.2253       0.2777       6.3455    2218.4148       2.9592     -17.1250    4493.0000
 2228.2404      43.9603      19.0116      21.4297      31.7653      71.7836      13.9308     311.0000       0.2368       0.2091      18.5854      68.0180     453.3904     159.9734      52.1810       0.2214       0.2736       6.1066    2305.0632       4.6000     -17.1250    4451.0000
 2228.3928      77.1191      58.4188      50.0910      80.6823      85.6042      11.6817     311.0000       0.2487       0.2214      18.6035      61.5257     453.9367     170.8877      52.1810       0.2183       0.2702       6.0826    2284.7249       7.6400     -18.9375    4413.0000
 2228.5452     238.9187      78.1065     107.4167     142.9926     293.3754       3.4086     311.0000       0.2614       0.2345      18.6309      56.4431     423.6162     177.1491      52.1810       0.1823       0.2339       6.1230    2263.0371       6.8979     -21.3750    4428.0000
 2228.6976     169.1242     108.5903     737.6949     983.4396    1670.7040       0.5986     311.0000       0.2497       0.2224      18.6946      55.1545     443.0104     172.9000      52.1810       0.1072       0.1545       6.0971    2282.9993       5.7454     -22.4375    4371.0000
 2228.8500     173.7321      81.6818     754.9612    1950.0000    1301.5786       0.7683     311.0000       0.2300       0.2020      18.8448      60.1606     425.8015     178.4270      52.1810       0.0830       0.1280       6.1034    2316.6926       7.0881     -23.4375    4497.0000
 2229.0024     123.5155      57.5849     434.6520     257.5733     245.1344       4.0794     311.0000       0.2470       0.2196      18.8351      64.8058     357.7852     194.5794      52.1810       0.0944       0.1410       6.2887    2287.6848       7.1777     -22.0625    4551.0000
 2229.1548      74.2476      42.3233      94.5144     148.0206     119.0149       8.4023     311.0000       0.3299       0.3055      18.7625      68.1223     337.8448     171.3026      52.1810       0.2035       0.2558       6.5765    2145.8674       4.2617     -20.4375    4608.0000
 2229.3072      62.0292      37.9254      81.0995      90.9776      68.7306      14.5496     311.0000       0.3156       0.2907      18.5769      72.8282     341.3958     166.2977      52.1810       0.1555       0.2059       6.5495    2170.3252       3.2022     -19.0000    4507.0000
 2229.4596      58.0599      38.0882      79.9813      68.8988      54.4129      18.3780     311.0000       0.2941       0.2685      18.5069      72.3644     338.6642     119.7207      52.1810       0.1157       0.1637       6.1946    2207.0527       4.1996     -19.0000    4404.0000
 2229.6120      46.1429      40.3357      32.8265      41.6405      28.6612      34.8904     311.0000       0.2324       0.2045      18.6182      71.7560     329.9232     115.0708      52.1810       0.1225       0.1708       5.8445    2312.5706       4.7326     -19.4375    4403.0000
 2229.7644      27.6047      26.6175      27.8019      20.4247      17.9428      55.7328     311.0000       0.2816       0.2554      18.7012      65.5023     333.4742      86.4420      52.1810       0.1543       0.2044       5.8961    2228.5410       5.9766     -19.0625    4355.0000
 2229.9168      25.2741      47.8504      55.8863      43.9056      32.6220      30.6541     311.0000       0.3622       0.3390      18.6808      61.1181     318.9969      77.2827      52.1810       0.1206       0.1692       6.2709    2090.6082       3.3639     -17.1250    4388.0000
 2230.0692      29.5763      55.8894     110.0433      80.1437      55.1398      18.1357     311.0000       0.4367       0.4162      18.7462      55.1858     365.9800      60.0042      52.1810       0.1173       0.1657       6.6064    1963.2417       2.6989     -17.1250    4531.0000
 2230.2216      36.4550      65.1756      97.9432      76.3603      51.3341      19.4802     311.0000       0.4445       0.4243      18.7466      61.3982     356.6926      40.9594      52.1810       0.2645       0.3139       6.5707    1949.9149       1.9956     -17.1250    4596.0000
 2230.3740      40.8951      54.9678      66.7716      95.6525      34.9213      28.6358     311.0000       0.3534       0.3299      18.6274      68.9998     382.3694      52.3391      52.1810       0.5916       0.6251       6.2727    2105.6025       2.6180     -17.1250    4666.0000
 2230.5264      56.2755      50.0134      77.1823     124.1031      36.4785      27.4134     311.0000       0.2647       0.2380      18.5616      80.5932     408.5926      90.7652      52.1810       0.3918       0.4409       6.0405    2257.3672       4.0077     -17.1250    4524.0000
 2230.6788      75.6276      66.3230     115.4138     189.0054      53.5520      18.6734     311.0000       0.2963       0.2708      18.4131      79.1735     404.7683     110.2390      52.1810       0.2200       0.2722       6.1818    2203.2522       5.4964     -17.1250    4470.0000
 2230.8312     100.6043      86.9007     169.2710     273.9358      78.9823      12.6611     311.0000       0.3950       0.3730      18.3792      72.9198     399.8515     104.3515      52.1810       0.1697       0.2200       6.4492    2034.4821       3.3178     -17.1250    4410.0000
 2230.9836     188.5547     160.6585     320.3979     507.3489     140.5969       7.1125     311.0000       0.4261       0.4052      18.4383      66.6503     379.6378      83.5791      52.1810       0.2387       0.2890       6.3437    1981.4246       2.6035     -17.1250    4419.0000
 2231.1360     155.9835     234.6645    1950.0000    1950.0000    1941.1781       0.5152     311.0000       0.3555       0.3321      18.4601      66.2829     376.3600      65.8858      52.1810       0.2655       0.3157       5.7501    2102.0789       3.0220     -17.1250    4427.0000
 2231.2884     119.9077     286.5852    1950.0000    1950.0000    1950.0000       0.5000     311.0000       0.2609       0.2340      18.5353      62.0957     333.2011      48.4934      52.1810       0.2205       0.2725       4.9882    2263.8943       4.1615     -14.5625    4500.0000
 2231.4408      98.6943     259.2542    1950.0000    1950.0000    1950.0000       0.5000     311.0000       0.2267       0.1986      18.6930      58.3747     344.6737      17.6854      52.1810       0.1308       0.1798       4.4712    2322.3245       5.8331     -11.3750    4553.0000
 2231.5932      88.2088     176.7870    1477.1938    1947.8046    1950.0000       0.5004     311.0000       0.1928       0.1634      18.6814      49.7956     357.2390      10.5889      52.1810       0.0734       0.1165       4.2235    2380.3196       6.9614      -8.4375    4530.0000
 2231.7456      75.5626     106.7053     345.7177     282.8908     626.0597       1.5973     311.0000       0.1456       0.1146      18.5819      52.4320     328.5574      22.1224      52.1810       0.0647       0.1067       4.1451    2460.9531      11.6037      -7.3750    4489.0000
 2231.8980      65.5455      66.3288     113.8068     107.2667     214.1143       4.6704     311.0000       0.1166       0.0845      18.4770      54.9798     330.4695      29.8209      52.1810       0.0620       0.1039       4.1242    2510.5815      18.8048      -7.3750    4492.0000
 2232.0504      59.8345      46.7781      80.2547      66.7985     128.1121       7.8057     311.0000       0.0881       0.0550      18.2339      62.3039     323.6406      40.3519      52.1810       0.0964       0.1422       4.1115    2559.2673      30.2805      -6.7500    4494.0000
 2232.2028      53.2785      40.0528      58.7076      45.1640      84.2595      11.8681     311.0000       0.0740       0.0404      18.0733      61.3261     325.5527      41.4705      52.1810       0.1348       0.1837       4.0471    2583.3806      33.3840      -5.9375    4442.0000
 2232.3552      67.5910      44.1659      43.0658      39.9370      70.4652      14.1914     311.0000       0.0600       0.0258      18.1102      60.2686     321.1822      38.2113      52.1810       0.1439       0.1936       3.9607    2607.4609      30.1784      -5.6875    4420.0000
 2232.5076      92.5073      63.6023      72.5391      42.8340      63.1239      15.8419     311.0000       0.0531       0.0186      18.3309      59.8777     317.9043      29.2399      52.1810       0.1343       0.1833       3.8931    2619.2615      33.3421      -5.1250    4495.0000
 2232.6600     118.1491      85.9525      66.4373      54.2324      54.3846      18.3875     311.0000       0.0515       0.0170      18.6399      61.2689     309.1632      24.7030      52.1810       0.1143       0.1620       3.9924    2621.9592      50.6263      -4.8750    4514.0000
 2232.8124     157.9740      99.2192     104.5003      57.2000      46.7894      21.3724     311.0000       0.1109       0.0785      18.6075      59.4437     315.7190      20.0162      52.1810       0.1190       0.1667       4.4258    2520.4351     108.5981      -4.3125    4466.0000
 2232.9648     133.4961     138.6776     204.1073      69.0096      39.7868      25.1340     311.0000       0.2389       0.2112      18.5929      56.5897     315.4458      13.3481      52.1810       0.0887       0.1345       5.0638    2301.4705       9.5571      -3.8125    4427.0000
 2233.1172     139.8047      65.7359     236.9226     198.9494      56.8569      17.5880     311.0000       0.3696       0.3467      18.4664      52.6314     317.3580       7.2055      52.1810       0.0822       0.1278       5.7346    2077.9661       4.0064      -3.4375    4428.0000
 2233.2696      72.2872      55.7352      66.3081     101.1923      28.2555      35.3913     311.0000       0.4054       0.3837      18.4803      52.0592     313.5338       3.5148      52.1810       0.2158       0.2685       5.8901    2016.8145       2.6676      -3.5625    4496.0000
 2233.4220      91.1734      35.0924      96.1151     138.0978      36.2421      27.5922     311.0000       0.3405       0.3165      18.4295      57.9404     328.8306       8.7664      52.1810       0.2427       0.2960       5.5405    2127.7212       2.9205      -3.6250    4404.0000
 2233.5744     154.6904      31.7445      92.0960     131.9919      64.5472      15.4925     311.0000       0.2663       0.2396      18.4607      66.9736     337.0253      21.0197      52.1810       0.1109       0.1589       5.1595    2254.7075       4.5148      -2.1875    4400.0000
 2233.7268      94.2356      34.8599      82.5377     108.2226      86.3073      11.5865     311.0000       0.2774       0.2511      18.3478      67.9514     314.3532      28.1622      52.1810       0.1515       0.2018       5.2058    2235.6357       6.1077      -1.0625    4430.0000
 2233.8792      46.6342      29.1795      68.2984     105.7089     107.5634       9.2968     311.0000       0.2533       0.2262      18.2895      63.7875     351.7758      88.2752      52.1810       0.1750       0.2262       5.7131    2276.7839       5.8383      -0.8750    4376.0000
 2234.0316      27.6819      20.1939      31.2615      34.6603     128.0406       7.8100     311.0000       0.2486       0.2213      18.2847      57.0825     358.3316     136.7226      52.1810       0.1795       0.2310       6.1824    2284.9370       5.8956      -0.1875    4437.0000
 2234.1840      66.6586      25.1031      36.1441      38.9191      89.8482      11.1299     311.0000       0.2969       0.2713      18.1779      57.2435     377.4526     144.8393      52.1810       0.2097       0.2623       6.6626    2202.3796       5.0942       1.6875    4530.0000
 2234.3364      66.7866      53.1865     143.5878     141.3007     279.0936       3.5830     311.0000       0.4198       0.3987      18.4160      57.0116     360.5168     100.9132      52.1810       0.1089       0.1566       7.1124    1992.1738       3.0942       2.3750    4476.0000
 2234.4888     118.6773      95.6147     199.4377     225.6682     359.6296       2.7806     311.0000       0.5165       0.4990      18.4080      58.2284     361.6095      58.0331      52.1810       0.0547       0.0980       7.4719    1826.7003       2.0003       2.3750    4486.0000
 2234.6412      85.3984     193.2986     720.2610     405.2549     332.1407       3.0108     311.0000       0.5089       0.4911      18.3286      55.6806     376.9063      55.6211      52.1810       0.1148       0.1630       7.5225    1839.7114       1.8141       2.4375    4449.0000
 2234.7936     108.1731     127.5316     750.9227     197.3592     338.5624       2.9537     311.0000       0.4843       0.4655      18.3068      57.6427     381.8231      58.3956      52.1810       0.3096       0.3609       7.3948    1881.8737       1.8589       2.3750    4404.0000
 2234.9460     107.6174     100.0411     193.1523     117.9345     358.2162       2.7916     311.0000       0.4425       0.4222      18.1627      61.0704     381.8231      79.6435      52.1810       0.3973       0.4420       7.2083    1953.3083       2.0323       2.3750    4419.0000
 2235.0984     117.9000      71.9247     150.5028      80.5530     191.0056       5.2354     311.0000       0.3479       0.3242      18.1979      73.5973     388.9252     139.4849      52.1810       0.3462       0.3929       6.9763    2115.1223       2.5566       2.1250    4402.0000
 2235.2508     155.6873      51.3908     111.7424      88.3712     232.6792       4.2978     311.0000       0.2909       0.2651      18.1964      72.1777     385.1010     176.5196      52.1810       0.3073       0.3564       6.7727    2212.6169       3.8190       0.5000    4413.0000
 2235.4032     176.9183      49.6354     104.6242      96.8648     271.0252       3.6897     311.0000       0.2836       0.2575      18.2151      71.9221     384.5547     194.6640      52.1810       0.3537       0.4026       6.6868    2225.1230       3.9418      -1.1875    4451.0000
 2235.5556     162.0007      53.5687     106.8613     111.1311     296.1928       3.3762     311.0000       0.2783       0.2521      18.2233      67.6632     358.8779     231.5075      52.1810       0.3134       0.3652       6.7088    2234.0835       3.4778      -2.5625    4412.0000
 2235.7080     115.4709      68.8267     133.2312     316.3389     154.0763       6.4903     311.0000       0.2513       0.2241      18.3189      70.0968     337.0253     286.7990      52.1810       0.1408       0.1905       6.7820    2280.2290       3.8266      -2.7500    4452.0000
 2235.8604     123.1534      87.1683     365.1645     553.0804     704.0779       1.4203     311.0000       0.2082       0.1794      18.3127      69.9668     356.9658     341.5563      52.1810       0.0894       0.1359       6.8562    2353.9949       5.5894      -2.9375    4372.0000
 2236.0128      78.2411      92.5734     275.2842     483.8295     402.9386       2.4818     311.0000       0.2045       0.1756      18.3088      70.7319     354.5074     351.3932      52.1810       0.0975       0.1445       6.9549    2360.2305       5.5004      -3.8125    4362.0000
 2236.1652      53.7547      74.8169     101.7039     127.0727     197.0267       5.0755     311.0000       0.1949       0.1656      18.1598      68.2983     349.3174     359.7260      52.1810       0.1769       0.2283       6.9995    2376.7793       4.5257      -4.8750    4334.0000
 2236.3176      45.9964      46.7247      69.0462      80.2990     131.6607       7.5953     311.0000       0.2337       0.2059      18.1655      74.7880     347.9516     331.6657      52.1810       0.2797       0.3320       7.0663    2310.3384       4.1149      -6.8750    4418.0000
 2236.4700      45.3045      37.0970      52.4002      51.1502     112.3919       8.8974     311.0000       0.3187       0.2940      18.1641      78.0616     353.9611     261.2165      52.1810       0.3664       0.4147       7.1026    2164.9751       2.9927      -7.3750    4438.0000
 2236.6224      42.8611      41.6961      56.4340      52.1957     250.7614       3.9879     311.0000       0.3421       0.3182      18.1875      81.3064     353.9611     222.7721      52.1810       0.3619       0.4089       6.9834    2125.0044       2.5880      -8.3125    4523.0000
 2236.7748      45.8177      33.6320      50.8126      36.3837     132.4170       7.5519     311.0000       0.3604       0.3371      18.2869      77.2504     338.6642     187.9836      52.1810       0.1934       0.2432       6.7818    2093.7312       2.6386      -8.9375    4550.0000
 2236.9272      30.4624      39.9193      41.7549      32.3146     173.7916       5.7540     311.0000       0.3319       0.3076      18.2237      73.2117     367.0726     194.0484      52.1810       0.1927       0.2432       6.5643    2142.4670       2.6658     -11.0625    4539.0000
 2237.0796      25.0589      52.6526      24.0145      21.5349     155.4173       6.4343     311.0000       0.2950       0.2693      18.0590      70.7781     380.7305     205.8251      52.1810       0.3386       0.3904       6.4146    2205.6235       2.9462     -13.5625    4467.0000
 2237.2320      36.9492      38.7739      49.8848      54.7443     214.5755       4.6604     311.0000       0.2191       0.1907      17.9752      68.7060     341.9421     243.0027      52.1810       0.2570       0.3095       6.2848    2335.3201       3.5988     -14.6875    4486.0000
 2237.3844      95.2142      79.9530      64.0776      57.8226     216.4734       4.6195     311.0000       0.1679       0.1376      18.0619      67.4892     383.4621     285.7616      52.1810       0.1228       0.1714       6.2763    2422.9280       5.0470     -16.0625    4489.0000
 2237.5368     235.5129     100.3922     163.4685     150.1538     329.7648       3.0325     311.0000       0.2181       0.1897      17.9784      67.2864     351.2295     273.8707      52.1810       0.1358       0.1852       6.4733    2337.0596       4.2601     -17.1250    4467.0000
 2237.6892     269.8630     119.7410     359.0464     109.3678     440.6668       2.2693     311.0000       0.2899       0.2641      18.1031      64.4912     355.0537     240.8675      52.1810       0.2499       0.3027       6.6942    2214.3140       3.2502     -17.1250    4376.0000
 2237.8416     103.4270      58.2436      73.4350     103.6252      81.4245      12.2813     311.0000       0.3133       0.2883      18.1321      64.4912     360.7900     209.5106      52.1810       0.2635       0.3163       6.7120    2174.2297       2.9039     -18.8125    4470.0000
 2237.9940     150.5478      99.0663     105.8383      55.8944     100.2417       9.9759     311.0000       0.2892       0.2634      18.2306      62.3925     359.4242     184.8779      52.1810       0.2190       0.2712       6.5211    2215.4219       3.3798     -20.1875    4435.0000
 2238.1464     116.8651     246.9277      76.4161      78.9650      67.6893      14.7734     311.0000       0.2387       0.2110      18.1358      64.6233     368.1653     187.6233      52.1810       0.1811       0.2325       6.2621    2301.8325       3.8951     -20.6875    4510.0000
 2238.2988     114.2554     107.7565      80.8981      39.6659      72.0815      13.8732     311.0000       0.2531       0.2259      18.1010      61.3785     375.2673     179.4860      52.1810       0.1287       0.1778       6.2571    2277.2666       5.3311     -20.8125    4491.0000
 2238.4512      51.1643      51.5897      86.3109      35.5776      50.2690      19.8930     311.0000       0.3398       0.3158      18.1074      61.2463     366.5263     164.3658      52.1810       0.0960       0.1430       6.5724    2128.9368       3.9905     -20.5000    4494.0000
 2238.6036      16.6292      43.4779      21.6914      19.9477      20.2489      49.3854     311.0000       0.4233       0.4023      18.1355      62.2985     343.0348     151.4198      52.1810       0.1140       0.1622       6.9740    1986.1688       2.8842     -20.6875    4497.0000
 2238.7560      15.6385      18.9081      14.7049      22.6887      16.7875      59.5681     311.0000       0.4254       0.4045      18.2122      66.3546     354.5074     154.8822      52.1810       0.2218       0.2746       7.0683    1982.5455       2.2566     -21.8750    4435.0000
 2238.9084      51.9636      51.5894      49.1720      50.2787      24.0533      41.5743     311.0000       0.3323       0.3080      18.1467      68.3826     366.7995     189.9871      52.1810       0.2622       0.3158       6.8031    2141.8281       2.6651     -22.2500    4417.0000
 2239.0608      92.5938      82.3375      70.9648      76.6522      71.2459      14.0359     311.0000       0.2087       0.1799      17.9970      61.4342     368.1653     250.6330      52.1810       0.1565       0.2070       6.4275    2353.1899       4.1590     -22.2500    4405.0000
 2239.2132     418.0305     439.6146     289.7443     461.4627     124.4135       8.0377     311.0000       0.2074       0.1785      17.9456      53.5895     382.6426     252.5907      52.1810       0.0601       0.1040       6.3150    2355.4146       7.0828     -22.5625    4312.0000
 2239.3656    1833.0328    1312.6962    1258.4354    1715.9445     211.3166       4.7322     311.0000       0.3013       0.2759      17.8454      57.4428     392.7494     194.9326      52.1810       0.1247       0.1736       6.3469    2194.7515       4.3630     -24.9375    4417.0000
 2239.5180    1508.8228     406.9538     548.3895     655.6377     187.9209       5.3214     311.0000       0.3499       0.3263      18.0107      67.5979     370.3505     129.2299      52.1810       0.3453       0.3982       6.1723    2111.6707       3.1320     -26.9375    4524.0000
 2239.6704     230.0497     173.9928     170.0615     190.0441     140.1096       7.1373     311.0000       0.2931       0.2673      18.1715      76.6593     328.8306      97.7499      52.1810       0.2905       0.3421       5.5880    2208.8831       3.3587     -26.9375    4487.0000
 2239.8228     170.6847      62.0971      62.2290      60.7290      35.1949      28.4132     311.0000       0.1668       0.1365      18.2712      79.2485     314.0800     103.6177      52.1810       0.1711       0.2221       4.8476    2424.7927       6.7092     -26.9375    4628.0000
 2239.9752      92.0475      61.2036      66.5476      77.2986      52.5318      19.0361     311.0000       0.1304       0.0988      18.0727      72.9616     329.3769      94.4591      52.1810       0.1174       0.1657       4.4792    2487.0022      15.3884     -26.7500    4549.0000
 2240.1276      88.9551     163.9960     213.1597     210.3736     139.3054       7.1785     311.0000       0.1209       0.0890      17.9349      63.8355     371.4431     117.3894      52.1810       0.0772       0.1213       4.6265    2503.2114      12.9821     -26.6875    4442.0000
 2240.2800     175.2188     397.5905     257.5569     393.2725     298.6763       3.3481     311.0000       0.1165       0.0844      17.9336      54.5539     385.1010     168.4787      52.1810       0.0611       0.1029       5.0779    2510.7327      11.2490     -26.5625    4417.0000
 2240.4324     127.0964     290.1178     265.9554     374.4427     343.6917       2.9096     311.0000       0.1223       0.0904      17.9503      54.8517     350.6832     210.7699      52.1810       0.0636       0.1052       5.5339    2500.8862      10.0777     -26.3125    4354.0000
 2240.5848      99.9466     198.9423     151.4133     176.1648     210.6932       4.7462     311.0000       0.1591       0.1285      17.9510      59.1105     335.9327     221.9164      52.1810       0.0812       0.1253       5.9143    2437.9185       8.2618     -25.3750    4394.0000
 2240.7372     144.0291     157.8515     123.6831     149.7458     228.3493       4.3793     311.0000       0.2039       0.1750      17.9555      64.3834     358.8779     207.2315      52.1810       0.1056       0.1519       6.1860    2361.3096       5.6961     -23.3125    4487.0000
 2240.8896     137.5022     112.1570     180.4832      93.4524     327.5872       3.0526     311.0000       0.2241       0.1959      17.9427      65.6879     344.4006     208.6859      52.1810       0.1634       0.2141       6.3838    2326.8396       5.1934     -17.9375    4605.0000
 2241.0420     204.5146     193.2626      75.2610      42.4020     116.5634       8.5790     311.0000       0.2770       0.2507      17.8564      67.2904     328.8306     193.1674      52.1810       0.1558       0.2063       6.5780    2236.3689       4.5175     -13.8750    4852.0000
 2241.1944      76.2291      64.5408      63.9869      41.9939      76.3666      13.0947     311.0000       0.3547       0.3312      17.9154      64.6539     332.9279     165.0685      52.1810       0.1349       0.1843       6.7837    2103.4531       3.5261     -14.0000    4796.0000
 2241.3468      77.9418      55.6041      40.8739      42.4004      60.6735      16.4817     311.0000       0.3874       0.3652      17.7978      63.4572     345.2200     139.3453      52.1810       0.1325       0.1817       6.8192    2047.4949       2.9681     -12.8750    4684.0000
 2241.4992      80.1632      72.6511      40.8847      36.3447      40.5274      24.6747     311.0000       0.3488       0.3251      17.8779      64.6940     358.8779     134.3417      52.1810       0.1843       0.2360       6.6019    2113.5361       3.1410     -13.7500    4580.0000
 2241.6516      61.9133      73.3496      42.1518      34.2281      29.1697      34.2821     311.0000       0.2919       0.2661      18.0067      66.0120     388.3789     148.4454      52.1810       0.1633       0.2140       6.3872    2210.9138       4.0379     -14.0000    4461.0000
 2241.8040     119.8783     151.3491      91.5058      89.5747      82.1896      12.1670     311.0000       0.2907       0.2649      17.9354      70.4736     356.6926     168.9949      52.1810       0.1272       0.1762       6.4817    2212.9268       4.3226     -12.8750    4435.0000
 2241.9564      91.2237     511.0839     207.5782     189.6289     108.5628       9.2113     311.0000       0.3305       0.3061      17.9940      68.2428     337.5716     200.5751      52.1810       0.1325       0.1818       6.8665    2144.9277       3.7600     -11.1250    4417.0000
 2242.1088     223.4870    1082.7642    1173.5382    1144.6858     230.2003       4.3440     311.0000       0.4077       0.3862      17.9158      70.5753     335.9327     210.7292      52.1810       0.2755       0.3273       7.3185    2012.7563       2.6316      -9.4375    4370.0000
 2242.2612     615.7659     297.7780    1765.9679    1950.0000     257.0473       3.8903     311.0000       0.4752       0.4561      17.8585      64.2884     356.1463     183.4892      52.1810       0.3331       0.3861       7.4322    1897.4268       2.0278      -9.2500    4443.0000
 2242.4136     364.6770     137.2361     211.7429     227.8937     278.6517       3.5887     311.0000       0.4531       0.4332      17.7995      61.8044     331.5622     145.3667      52.1810       0.1718       0.2230       6.9372    1935.1851       1.9058      -9.0625    4510.0000
 2242.5660     126.0759      52.0176     165.9555     160.2015     165.5027       6.0422     311.0000       0.3571       0.3337      17.7433      57.3428     348.2248     102.1101      52.1810       0.0802       0.1257       5.9367    2099.4375       2.4738      -7.5625    4501.0000
 2242.7184      87.3775      57.2531      86.0996      97.5068     109.5821       9.1256     311.0000       0.2602       0.2333      17.7452      61.7830     374.7210      59.0651      52.1810       0.0863       0.1315       4.8534    2264.9958       3.7981      -7.3750    4633.0000
 2242.8708      50.1588      41.5417      62.7300      52.2362      74.6893      13.3888     311.0000       0.2098       0.1810      17.8016      63.8614     400.3978      47.1563      52.1810       0.0945       0.1399       4.5056    2351.2861       6.5657      -7.3750    4590.0000
 2243.0232      59.5142      78.1568      82.2892      99.4726      71.8465      13.9186     311.0000       0.2618       0.2349      17.7641      68.3328     395.4810      34.1609      52.1810       0.0757       0.1193       4.7760    2262.3604       6.6318      -7.3750    4471.0000
 2243.1756      38.7989      61.6168      98.7367     100.1303      81.9836      12.1976     311.0000       0.3020       0.2766      17.8850      70.7878     374.1747      77.5511      52.1810       0.0784       0.1229       5.5522    2193.5576       4.1493      -7.3750    4438.0000
 2243.3280      42.5498      39.7243     100.2056      75.1052      69.5888      14.3701     311.0000       0.3383       0.3142      17.8733      68.1514     353.4147     122.9730      52.1810       0.1113       0.1589       6.0763    2131.5256       3.0686      -6.6875    4347.0000
 2243.4804      41.4593      27.3661      32.1535      31.6667      24.5916      40.6643     311.0000       0.2885       0.2626      17.7605      67.4305     328.8306     180.2039      52.1810       0.1828       0.2344       6.2717    2216.6782       3.3116      -6.3750    4373.0000
 2243.6328      36.4936      21.4033      27.5839      21.3143      13.0587      76.5775     311.0000       0.2204       0.1920      17.8044      64.5913     353.9611     183.9094      52.1810       0.2408       0.2938       6.0386    2333.1960       3.8894      -6.3125    4411.0000
 2243.7852      40.1917      33.4401      46.0440      37.3659      31.9034      31.3446     311.0000       0.1954       0.1662      17.7296      66.2137     380.7305     138.1795      52.1810       0.2174       0.2692       5.7535    2375.7915       5.2617      -6.6250    4483.0000
 2243.9376      61.6089      53.3381      75.6088      59.5021      45.7865      21.8405     311.0000       0.2291       0.2011      17.7072      69.1557     379.6378      99.1299      52.1810       0.1635       0.2139       5.7475    2318.2446       7.2052      -7.3750    4550.0000
 2244.0900      34.5195      57.6257      44.8937      37.7500      39.9935      25.0041     311.0000       0.3202       0.2955      17.6934      68.6720     370.3505      90.2920      52.1810       0.2445       0.2948       6.1622    2162.3857       4.7959      -8.5625    4626.0000
 2244.2424      28.2040      54.2467      66.7449      47.6682      54.9010      18.2146     311.0000       0.3296       0.3053      17.6237      73.1336     396.5736     156.7336      52.1810       0.2946       0.3465       6.6346    2146.3232       3.1576     -11.0000    4607.0000
 2244.3948      82.7357      71.6820     102.3054      63.7908      84.1853      11.8786     311.0000       0.2945       0.2688      17.9114      67.4551     437.0009     231.5688      52.1810       0.2436       0.2959       6.8974    2206.4236       2.7692     -12.0625    4550.0000
 2244.5472     138.5469     252.6062     150.3600      90.1798     121.6892       8.2177     311.0000       0.2604       0.2335      17.9843      63.8655     381.8231     272.2005      52.1810       0.2073       0.2595       6.9219    2264.7295       3.9348     -12.9375    4443.0000
 2244.6996     208.7604     558.9870     683.8893     255.4236     460.7180       2.1705     311.0000       0.2527       0.2255      17.9580      60.1945     402.0368     266.7334      52.1810       0.1677       0.2186       6.7961    2277.8994       5.0861     -12.4375    4383.0000
 2244.8520     203.2724     517.1536    1950.0000    1950.0000    1950.0000       0.5000     311.0000       0.2148       0.1862      17.7051      64.8589     351.2295     254.6270      52.1810       0.1816       0.2327       6.5345    2342.7720       6.5768     -17.1250    4419.0000
 2245.0044     159.9842     266.2651    1264.8710    1950.0000    1950.0000       0.5012     311.0000       0.1479       0.1169      17.6742      68.3238     341.9421     250.5684      52.1810       0.1818       0.2333       6.1657    2457.0530       9.5847     -16.3125    4463.0000
 2245.1568     108.6626     156.3289     508.1526     536.0995     781.4474       1.2797     311.0000       0.1387       0.1074      17.6364      68.5472     345.7664     219.7318      52.1810       0.1574       0.2079       5.8952    2472.7759      12.4555     -16.5625    4465.0000
 2245.3092      96.0745     155.2929     181.0982     252.1146     375.3519       2.6642     311.0000       0.1727       0.1426      17.6444      64.9980     341.3958     167.3288      52.1810       0.1383       0.1876       5.7342    2414.7178       8.2244     -15.9375    4540.0000
 2245.4616      57.7151     126.6417     130.0048     146.4451     208.1247       4.8048     311.0000       0.1666       0.1363      17.7280      64.9980     334.2937     128.6063      52.1810       0.1126       0.1604       5.5213    2425.0767       6.8323     -14.5625    4486.0000
 2245.6140      60.9518     101.0455      85.0475      92.5339     122.1872       8.1842     311.0000       0.1804       0.1506      17.7433      65.6064     329.9232      94.0661      52.1810       0.1033       0.1506       5.3816    2401.5557       8.2580     -13.9375    4497.0000
 2245.7664      51.8692      75.4133      89.5964      83.8868     118.5015       8.4387     311.0000       0.2166       0.1881      17.6357      68.5472     310.2559      94.1741      52.1810       0.1302       0.1793       5.5585    2339.6299       6.5176     -13.8125    4434.0000
 2245.9188      36.8080      63.2809      48.5281      48.4340      60.9321      16.4117     311.0000       0.2679       0.2412      17.6743      74.2257     340.8495     134.1143      52.1810       0.1699       0.2210       6.0475    2251.9663       4.9482     -14.9375    4450.0000
 2246.0712      35.9443      51.2327      36.6316      37.1600      40.8983      24.4509     311.0000       0.2959       0.2703      17.6698      74.6313     390.5641     178.2076      52.1810       0.1732       0.2244       6.5567    2204.0110       3.4862     -15.1875    4512.0000
 2246.2236      25.2873      50.1609      34.1802      32.5464      34.9996      28.5718     311.0000       0.3095       0.2844      17.6461      75.4239     351.2295     198.4848      52.1810       0.1840       0.2354       6.8396    2180.7690       3.2581     -16.0625    4525.0000
 2246.3760      35.6787      74.6371      57.7171      56.7567      58.2057      17.1805     311.0000       0.3511       0.3275      17.7194      64.8622     384.2815     176.9347      52.1810       0.2008       0.2517       6.9837    2109.6555       2.8360     -16.3750    4525.0000
 2246.5284      51.3213     142.8655     139.8697     116.3095      94.3275      10.6014     311.0000       0.3888       0.3666      17.7801      67.0930     373.6284     155.4334      52.1810       0.2481       0.2998       7.0505    2045.1600       2.6962     -17.1250    4487.0000
 2246.6808      87.6480     157.7130     141.7988     138.5695     113.0966       8.8420     311.0000       0.4066       0.3851      17.8090      61.2964     382.3694     138.5862      52.1810       0.2953       0.3473       6.9756    2014.6613       2.7277     -17.1250    4449.0000
 2246.8332     117.5391     150.1296     236.7971     237.0664     147.9441       6.7593     311.0000       0.3432       0.3193      17.7218      62.1235     387.2863     147.1430      52.1810       0.3404       0.3931       6.6067    2123.1780       3.1528     -17.9375    4445.0000
 2246.9856     131.0321     182.7194     403.1089     440.9223      97.2302      10.2849     311.0000       0.2193       0.1909      17.6138      55.6338     393.0226     158.1066      52.1810       0.2653       0.3182       5.9217    2335.0327       4.2658     -17.1250    4446.0000
 2247.1380     117.4695     235.9661    1950.0000    1950.0000     132.1713       7.5659     311.0000       0.0888       0.0557      17.6035      51.5118     321.1822     157.5601      52.1810       0.1145       0.1628       5.1113    2558.1736       9.4036     -17.0625    4422.0000
 2247.2904      94.2071     229.0671    1950.0000    1950.0000     308.6982       3.2394     311.0000       0.0405       0.0056      17.4130      53.1213     313.5338     142.9436      52.1810       0.0600       0.1035       4.6716    2640.7175      27.4259     -13.8125    4462.0000
 2247.4428      51.7669     186.2639     484.3389     812.2820     161.1510       6.2054     311.0000       0.0670       0.0330      17.5026      51.4988     311.8948     149.7164      52.1810       0.0598       0.1024       4.8498    2595.4985      57.2903      -9.0625    4436.0000
 2247.5952      42.1056      84.1669      80.5188     104.3901      54.9711      18.1914     311.0000       0.1309       0.0993      17.6706      52.7156     311.8948     191.0675      52.1810       0.0976       0.1433       5.5215    2486.1838      14.2880      -7.3750    4498.0000
 2247.7476      26.0086      35.3719      58.8672      70.4866      44.6105      22.4163     311.0000       0.2288       0.2007      17.6735      54.7567     320.6359     211.1671      52.1810       0.1301       0.1789       6.2464    2318.7944       6.6328      -7.3750    4497.0000
 2247.9000      28.3319      34.4222      39.0212      48.0202      28.5371      35.0422     311.0000       0.3318       0.3075      17.6413      55.2269     344.6737     182.7000      52.1810       0.1948       0.2469       6.7355    2142.6443       3.6025      -7.3750    4542.0000
 2248.0524      31.7799      36.8742      20.7738      24.6283      19.0831      52.4024     311.0000       0.3595       0.3362      17.6297      61.7166     377.4526     153.0079      52.1810       0.2281       0.2807       6.8652    2095.2227       2.7902      -7.3750    4574.0000
 2248.2048      20.9020      17.4129      23.9963      26.0751      20.5188      48.7357     311.0000       0.3486       0.3249      17.5436      61.8991     333.2011     145.4219      52.1810       0.2392       0.2909       6.9004    2113.9353       3.0607      -7.3750    4528.0000
 2248.3572      23.4806      23.6114      45.7193      44.6288      47.0729      21.2436     311.0000       0.3454       0.3216      17.5455      66.9045     296.5980     169.8180      52.1810       0.2765       0.3261       7.0311    2119.4358       2.8078      -7.3750    4467.0000
 2248.5096      28.5958      41.6768      50.3951      60.7401      42.8241      23.3513     311.0000       0.4149       0.3936      17.5707      65.6387     327.7379     167.3341      52.1810       0.3105       0.3568       7.2913    2000.4963       2.1502      -7.3750    4495.0000
 2248.6620      43.2747      36.8802      78.7546      96.8749      73.2894      13.6445     311.0000       0.4723       0.4531      17.5169      63.0226     359.4242     147.6016      52.1810       0.3831       0.4256       7.3253    1902.3124       1.6496      -7.3750    4358.0000
 2248.8144      49.5162      41.4495      94.1673     165.3567     107.8606       9.2712     311.0000       0.4319       0.4112      17.5365      63.6310     364.8874     140.8448      52.1810       0.4346       0.4744       6.9303    1971.4419       1.8026      -9.6875    4425.0000
 2248.9668      63.4740      43.3280     102.3204     273.3835     116.6995       8.5690     311.0000       0.3043       0.2790      17.4562      65.9108     387.2863     163.9671      52.1810       0.3644       0.4121       6.2705    2189.6152       2.6163     -12.6250    4432.0000
 2249.1192     106.4113      96.2019     311.0238     390.1153     435.1308       2.2982     311.0000       0.1999       0.1708      17.5341      73.0204     406.9536     177.4654      52.1810       0.2504       0.3023       5.7661    2368.2371       5.7454     -13.3125    4397.0000
 2249.2716      70.1579     162.4026     495.3200    1525.8621     308.6930       3.2395     311.0000       0.1702       0.1401      17.5220      75.8596     351.7758     184.5200      52.1810       0.1339       0.1831       5.7034    2418.9092       8.3863     -12.0625    4410.0000
 2249.4240      77.0512     147.3981     254.2385     310.8844     151.3563       6.6069     311.0000       0.2102       0.1815      17.4977      78.9017     323.0943     200.2149      52.1810       0.1018       0.1492       6.0400    2350.5098       5.7521     -10.1250    4389.0000
 2249.5764      44.4284     106.3246     150.4375     143.0210      70.4336      14.1978     311.0000       0.2652       0.2384      17.4664      77.0649     338.6642     220.7363      52.1810       0.2574       0.3101       6.4790    2256.5806       3.4636      -9.6875    4432.0000
 2249.7288      53.2033      37.6027      40.3951      41.9304      25.2300      39.6354     311.0000       0.2856       0.2597      17.4759      76.4565     382.9157     227.9544      52.1810       0.3173       0.3693       6.6676    2221.5549       3.1587      -9.9375    4551.0000
 2249.8812      73.5203      27.4887      30.7250      34.0108      25.3062      39.5161     311.0000       0.2777       0.2514      17.5215      72.5259     382.9157     200.0022      52.1810       0.2433       0.2950       6.5700    2235.1541       3.4505      -8.0625    4531.0000
 2250.0336      75.5435      43.2305      47.8197      61.3267      32.9400      30.3582     311.0000       0.2386       0.2109      17.5802      74.9595     387.8326     175.3497      52.1810       0.1997       0.2509       6.2699    2302.0054       3.9288      -7.3750    4695.0000
 2250.1860     102.2409     122.7067     167.0522     114.7583      85.2579      11.7291     311.0000       0.2332       0.2053      17.5672      72.1000     395.4810     148.3564      52.1810       0.1579       0.2082       6.0176    2311.2173       5.0243      -7.3750    4677.0000
 2250.3384      92.5740     210.1742     321.9724      74.4578     132.2214       7.5631     311.0000       0.2749       0.2485      17.4526      75.6251     385.6473     121.4955      52.1810       0.1977       0.2496       5.9356    2240.0010       4.0367      -7.3750    4556.0000
 2250.4908     118.6384     300.2199     921.8102     106.1926     230.9061       4.3308     311.0000       0.3084       0.2832      17.4772      78.9979     368.4384     117.4459      52.1810       0.2393       0.2915       5.9770    2182.6782       3.4113      -8.3125    4518.0000
 2250.6432      92.5544     167.8170     599.6309     251.1050     258.6939       3.8656     311.0000       0.3014       0.2760      17.4469      80.2350     313.5338     144.8154      52.1810       0.2246       0.2757       6.0245    2194.5547       3.2608      -8.5625    4452.0000
 2250.7956      86.2977     103.0227     202.8133     157.4233     120.4719       8.3007     311.0000       0.3005       0.2750      17.4248      78.4097     323.9137     162.7915      52.1810       0.2294       0.2806       6.0791    2196.1953       3.4048      -9.8125    4437.0000
 2250.9480      77.1112      59.5747     116.5730     157.6507      62.2123      16.0740     311.0000       0.2555       0.2285      17.3741      70.2709     337.0253     186.9936      52.1810       0.2077       0.2600       5.9537    2273.0137       3.5402     -11.1875    4441.0000
 2251.1004      65.0700      56.6716     105.4085     133.0372      47.2925      21.1450     311.0000       0.1988       0.1696      17.3812      68.6484     362.1558     187.6249      52.1810       0.1887       0.2404       5.6527    2370.0918       4.2062     -12.9375    4454.0000
 2251.2528      62.2250      70.9227     142.5656     202.9585     119.2175       8.3880     311.0000       0.1251       0.0933      17.3567      67.6344     345.7664     183.2044      52.1810       0.1646       0.2155       5.2027    2496.0920       5.8745     -12.8750    4461.0000
 2251.4052      67.9102     113.1707     259.0891     225.2867     156.2460       6.4002     311.0000       0.1124       0.0801      17.3692      70.3725     312.9874     156.8642      52.1810       0.1213       0.1699       4.9262    2517.7964       8.7233     -13.3125    4498.0000
 2251.5576      87.7532     121.5909     391.5973     410.4138     607.0093       1.6474     311.0000       0.1265       0.0947      17.3526      68.0913     325.0064     129.8292      52.1810       0.1320       0.1811       4.8065    2493.7505       7.1294     -12.1875    4482.0000
 2251.7100      89.5798      98.4003     336.1810     461.3966     273.9337       3.6505     311.0000       0.0978       0.0650      17.4027      63.2241     315.1727     128.2747      52.1810       0.1603       0.2104       4.6592    2542.7629       8.3652     -11.2500    4551.0000
 2251.8624      88.8197      81.2518     169.0262     341.6861     155.8725       6.4155     311.0000       0.0609       0.0267      17.2255      58.5596     312.4411     117.4946      52.1810       0.1042       0.1492       4.3869    2605.8767      13.1057     -12.1875    4505.0000
 2252.0148     109.5590      84.1917     183.0588     278.3443      90.6725      11.0287     311.0000       0.0271      -0.0083      17.2111      56.1608     330.1964     103.4029      52.1810       0.0345       0.0716       4.0792    2663.7231      23.0336     -10.8125    4477.0000
 2252.1672     242.5641     138.0534     272.5307     409.5723     237.0773       4.2180     311.0000       0.0225      -0.0130      17.2614      55.0092     346.3127      81.4431      52.1810       0.0120       0.0452       3.8662    2671.4783      70.7756      -9.8125    4419.0000
 2252.3196     273.2529     196.2336     681.5032     685.2058     347.6978       2.8761     311.0000       0.0196      -0.0160      17.3812      47.7083     310.8022      65.4151      52.1810       0.0293       0.0649       3.7428    2676.4473     509.6107     -10.1875    4449.0000
 2252.4720     306.7837     231.2857     563.1271     521.5500     311.8941       3.2062     311.0000       0.0188      -0.0168      17.4386      43.2622     310.8022      42.1896      52.1810       0.0462       0.0834       3.6554    2677.7676     456.4816      -9.3125    4442.0000
 2252.6244     142.5720     183.1682     241.4179     161.5019     155.6138       6.4262     311.0000       0.0164      -0.0193      17.3504      39.1409     309.9827      21.5385      52.1810       0.0441       0.0811       3.5499    2681.8782     466.3374      -8.7500    4481.0000
 2252.7768     111.1729     149.6793     187.1957     249.6896     110.0924       9.0833     311.0000       0.0168      -0.0189      17.3181      39.7983     309.1632       3.9847      52.1810       0.0317       0.0676       3.4122    2681.1956     445.0652      -7.3750    4606.0000
 2252.9292     108.3381     119.6963     152.4866     158.6501      98.1923      10.1841     311.0000       0.0262      -0.0092      17.1951      45.2739     309.1632      -1.9920      52.1810       0.0432       0.0800       3.3363    2665.1128     459.4159      -7.3750    4664.0000
 2253.0816     118.6506     152.6966     210.2568     133.9800      94.3753      10.5960     311.0000       0.0419       0.0071      17.2288      47.7076     309.1632      -2.7385      52.1810       0.0442       0.0820       3.3588    2638.3413     529.1522      -7.3750    4649.0000
 2253.2340     124.8462     129.2865     216.5298     202.8488     171.6539       5.8257     311.0000       0.1043       0.0718      17.2748      51.6637     309.1632       8.9853      52.1810       0.0354       0.0729       3.8732    2531.5645     229.0721      -7.3750    4557.0000
 2253.3864     203.7278     191.6535     243.7596     335.6502     264.1680       3.7855     311.0000       0.1868       0.1572      17.2032      55.5169     307.5243      63.0314      52.1810       0.0525       0.0924       4.7639    2390.5383      13.2703      -7.3750    4571.0000
 2253.5388     139.7656     104.8981     297.3697     242.2618     398.0344       2.5123     311.0000       0.2533       0.2261      17.1443      58.9646     325.5527     145.7877      52.1810       0.0668       0.1082       5.7293    2276.8682       6.6544      -7.3750    4483.0000
 2253.6912     110.7754      76.0535      92.6117     221.1877     243.5430       4.1061     311.0000       0.2333       0.2055      17.0604      60.6380     323.9137     238.7767      52.1810       0.1001       0.1452       6.1962    2310.9722       5.1339      -7.2500    4500.0000
 2253.8436      82.8265      50.0357      69.7372     257.4599     214.9378       4.6525     311.0000       0.2264       0.1983      17.0921      58.3653     358.0584     259.2764      52.1810       0.1033       0.1489       6.3447    2322.8518       6.0123      -6.5625    4513.0000
 2253.9960      67.4092      50.9681      73.7247     253.0555     218.2596       4.5817     311.0000       0.2462       0.2188      17.0785      56.5401     304.7927     250.0303      52.1810       0.1077       0.1547       6.5051    2288.9343       5.6510      -5.8125    4466.0000
 2254.1484      82.4508      86.8436     100.5609     230.9743     207.3985       4.8216     311.0000       0.2869       0.2609      17.1581      61.6101     327.1916     252.0151      52.1810       0.0991       0.1455       6.8157    2219.4819       4.9746      -4.4375    4484.0000
 2254.3008      94.8514     116.1005     293.2685     117.7696     579.2090       1.7265     311.0000       0.3190       0.2942      17.2890      63.6800     344.4006     267.9918      52.1810       0.0990       0.1455       7.1250    2164.5898       4.4674      -2.9375    4509.0000
 2254.4532     197.4582     189.1467     512.0474     277.3126     484.5992       2.0636     311.0000       0.3612       0.3379      17.2786      64.1889     357.5121     260.1458      52.1810       0.1335       0.1822       7.3170    2092.4036       3.4144      -2.8125    4476.0000
 2254.6056     236.6486     153.8625     550.4425     208.8286     192.6804       5.1899     311.0000       0.3917       0.3696      17.1492      64.5946     362.7021     237.2512      52.1810       0.1387       0.1880       7.3569    2040.2054       2.7963      -2.1250    4430.0000
 2254.7580     198.5434      81.2948     303.4867     164.7431     143.2534       6.9806     311.0000       0.4003       0.3785      17.2149      67.0282     373.0821     218.0313      52.1810       0.1174       0.1657       7.2802    2025.4650       2.5452      -1.0625    4568.0000
 2254.9104      69.4610      52.4271     117.9678      90.2556      74.0519      13.5040     311.0000       0.3618       0.3386      17.1353      71.1837     340.8495     235.8494      52.1810       0.1650       0.2158       7.1270    2091.3838       2.6091       0.5625    4618.0000
 2255.0628      80.5255      47.1344      97.1881     106.6657     109.0910       9.1667     311.0000       0.3315       0.3072      17.1064      70.7588     327.7379     242.4845      52.1810       0.2447       0.2975       6.9423    2143.0500       3.1989       1.8125    4711.0000
 2255.2152     194.7133      56.3995     106.8762      90.7917      89.2922      11.1992     311.0000       0.2833       0.2572      17.0876      72.3812     327.1916     238.7605      52.1810       0.2216       0.2739       6.6286    2225.6184       3.9095       2.3750    4637.0000
 2255.3676     127.9870      58.6761     102.7158      78.9397      77.3895      12.9216     311.0000       0.1966       0.1674      17.1270      69.9476     332.9279     215.0829      52.1810       0.1750       0.2263       6.1030    2373.7778       5.2642       2.3750    4564.0000
 2255.5200     113.2953      84.1095      98.1765      99.2680      61.4622      16.2702     311.0000       0.1267       0.0949      17.1463      66.9248     309.1632     156.4958      52.1810       0.1522       0.2025       5.5069    2493.3574       6.9421       2.3750    4467.0000
 2255.6724      84.1197     107.6181     106.9236     145.7483      83.7183      11.9448     311.0000       0.1464       0.1153      17.1335      63.3468     314.6264      99.9577      52.1810       0.1316       0.1808       5.2955    2459.7368      18.8581       2.3750    4436.0000
 2255.8248      81.7000     126.8649     114.2935     103.8642     103.8342       9.6307     311.0000       0.2810       0.2549      17.0206      66.7944     332.6548      54.4734      52.1810       0.1177       0.1661       5.7317    2229.4756       7.1114       2.3750    4525.0000
 2255.9772      91.3898     139.9259     290.6887     219.3878      67.0231      14.9202     311.0000       0.3980       0.3762      16.9060      66.7944     382.3694      84.8126      52.1810       0.1167       0.1650       6.5307    2029.3431       3.7153       2.3750    4573.0000
 2256.1296      84.1494     175.6952     147.8805     153.7257      97.2195      10.2860     311.0000       0.4157       0.3945      16.9570      69.5738     353.9611     167.3839      52.1810       0.1890       0.2407       7.1535    1999.0814       2.5507       2.3125    4531.0000
 2256.2820      68.9406     102.5117     125.9423     141.4730      93.7605      10.6655     311.0000       0.4326       0.4120      17.0469      70.9934     375.8137     210.0366      52.1810       0.2067       0.2586       7.5129    1970.1974       2.3901       1.0625    4575.0000
 2256.4344      68.8647      40.4918      80.4826     129.3932      92.1669      10.8499     311.0000       0.4849       0.4662      17.0863      75.0495     414.0557     183.1583      52.1810       0.2288       0.2806       7.5785    1880.7390       1.9594      -0.5000    4502.0000
 2256.5868      85.4428      28.6557      48.8498      66.7165      73.4232      13.6197     311.0000       0.4907       0.4721      17.0567      77.0649     409.1388     132.9578      52.1810       0.3030       0.3551       7.2413    1870.9788       1.7231      -1.8125    4454.0000
 2256.7392     111.6653      49.8505     109.8983     119.0923     159.3503       6.2755     311.0000       0.3657       0.3426      17.0042      73.0464     375.8137     119.3755      52.1810       0.3355       0.3861       6.3611    2084.6643       2.0688      -3.7500    4451.0000
 2256.8916     160.3743      92.9894     194.8689     222.0962     267.4399       3.7392     311.0000       0.1900       0.1605      16.9696      68.1792     377.9989     118.0332      52.1810       0.2280       0.2806       5.2726    2385.0984       3.8037      -3.7500    4471.0000
 2257.0440     198.1845     156.2612    1036.9114     923.7761    1569.7328       0.6371     311.0000       0.0850       0.0517      17.0118      64.7315     327.7379      97.1410      52.1810       0.1281       0.1771       4.4246    2564.6516      11.8406      -3.5000    4542.0000
 2257.1964     102.8330     210.5498    1950.0000    1950.0000    1600.6871       0.6247     311.0000       0.0558       0.0215      16.9791      65.5052     310.2559      66.0691      52.1810       0.1007       0.1475       3.9547    2614.5161      36.0524      -3.6250    4567.0000
 2257.3488      97.0395     207.3575    1570.4215    1546.0140     919.8892       1.0871     311.0000       0.0723       0.0386      16.9542      65.3759     309.7096      34.7812      52.1810       0.0933       0.1394       3.7379    2586.2891      46.0813      -2.8125    4576.0000
 2257.5012      86.6108     163.9217     301.4954     260.0420     202.2747       4.9438     311.0000       0.0824       0.0491      16.8663      61.9282     310.8022      18.0042      52.1810       0.1108       0.1578       3.6753    2569.0371      75.8268      -2.5625    4596.0000
 2257.6536      77.7171     103.3550     174.3419     139.1574     214.7366       4.6569     311.0000       0.0938       0.0609      16.8627      62.1310     312.4411       8.5747      52.1810       0.1018       0.1485       3.6860    2549.5181      77.1030      -2.2500    4542.0000
 2257.8060      88.6945      81.6730     129.7712      93.7716     140.2812       7.1285     311.0000       0.0828       0.0494      16.8757      65.0996     312.9874      26.8176      52.1810       0.1033       0.1500       3.7867    2568.4912      66.8696      -1.0625    4562.0000
 2257.9584      56.6694      49.0361      80.5809      65.0447     113.4891       8.8114     311.0000       0.0597       0.0255      16.8698      69.0529     311.3485      48.5661      52.1810       0.1160       0.1635       3.8513    2607.8694      27.8607      -0.1250    4559.0000
 2258.1108      57.6224      36.6059      43.9241      24.0055      55.9544      17.8717     311.0000       0.0282      -0.0071      16.8561      68.0389     311.3485      63.3728      52.1810       0.1289       0.1772       3.8525    2661.7434      28.5982       0.6250    4511.0000
 2258.2632      79.6596      74.4141      54.9443      41.1556      53.0672      18.8440     311.0000       0.0102      -0.0258      16.9098      68.4445     311.3485      58.5279      52.1810       0.1107       0.1578       3.7773    2692.6035      32.6515       1.7500    4550.0000
 2258.4156      81.2831      92.2310     139.4908     106.8003      96.6735      10.3441     311.0000       0.0108      -0.0252      16.9640      63.4772     315.1727      38.9485      52.1810       0.0903       0.1357       3.6647    2691.6064     166.6263       2.2500    4564.0000
 2258.5680      94.7779     161.7065     232.9087     140.1198     131.9540       7.5784     311.0000       0.0145      -0.0213      16.8665      64.4422     332.6548      26.8545      52.1810       0.0741       0.1173       3.5559    2685.1917     216.6427       2.3750    4557.0000
 2258.7204     125.3799     217.6973     192.9433     127.4315     110.6607       9.0366     311.0000       0.0222      -0.0134      16.8484      63.2254     312.7143      27.7011      52.1810       0.0711       0.1142       3.5957    2672.0786     255.7232       2.3750    4478.0000
 2258.8728     121.2262     163.9372     234.2028     156.3880      83.7615      11.9387     311.0000       0.0571       0.0228      16.8372      64.6450     312.9874      44.1978      52.1810       0.0919       0.1373       3.8033    2612.4202     135.8768       2.3750    4491.0000
 2259.0252     114.2698     158.2378     255.9547     181.5975      70.2895      14.2269     311.0000       0.1006       0.0679      16.8369      65.7080     311.8948      69.4261      52.1810       0.1131       0.1604       4.1029    2537.9214      19.7532       2.3750    4528.0000
 2259.1776     103.0289     141.6231     286.9106     177.0800      64.6568      15.4663     311.0000       0.1087       0.0763      16.8140      63.5506     312.4411      95.3259      52.1810       0.1467       0.1964       4.2283    2524.0830       9.5414       2.3750    4491.0000
 2259.3300      98.2689      98.6137     137.1938     148.6010      68.3422      14.6322     311.0000       0.0749       0.0413      16.7790      62.7394     311.0753      90.0953      52.1810       0.1352       0.1839       4.0709    2581.9265      10.4088       2.6875    4515.0000
 2259.4824      75.0757     100.1421     134.4385     156.0873     109.6710       9.1182     311.0000       0.0429       0.0081      16.7984      60.5086     325.0064      61.1284      52.1810       0.0864       0.1314       3.7681    2636.6404      22.6387       5.1875    4531.0000
 2259.6348      80.4854     186.6148     256.8542     300.3289     143.8044       6.9539     311.0000       0.0507       0.0161      16.7973      62.2604     309.1632      37.8330      52.1810       0.0676       0.1112       3.7602    2623.3677     255.7260       6.8125    4489.0000
 2259.7872      87.6634     157.7314     320.7610     346.8325     248.3176       4.0271     311.0000       0.0861       0.0529      16.8140      64.3031     309.9827      51.1162      52.1810       0.0984       0.1448       4.0906    2562.7551      28.2280       8.9375    4449.0000
 2259.9396      75.4919     107.8470     158.2427     261.1202     235.3034       4.2498     311.0000       0.0977       0.0649      16.7892      68.1564     311.8948      96.5629      52.1810       0.1558       0.2061       4.5593    2542.8699      11.2833      11.8125    4487.0000
 2260.0920      60.8151      76.4438     103.0080     192.8474     203.3712       4.9171     311.0000       0.0910       0.0580      16.7706      70.1844     310.2559     121.3949      52.1810       0.1925       0.2444       4.6916    2554.3110       7.4351      12.1250    4484.0000
 2260.2444      92.5603      86.2010     120.8389     209.9927     171.8663       5.8185     311.0000       0.0567       0.0224      16.7811      71.3665     310.8022     127.5725      52.1810       0.1404       0.1901       4.5067    2613.0793       9.7314      12.8750    4557.0000
 2260.3968     109.9595     131.0188     185.0240     251.6570     251.9973       3.9683     311.0000       0.0467       0.0120      16.7530      70.5553     323.6406      93.9229      52.1810       0.1117       0.1593       4.1839    2630.1790      20.8248      14.8125    4492.0000
 2260.5492     132.0995     164.4193     220.2764     162.7750     397.9973       2.5126     311.0000       0.0438       0.0090      16.6786      67.7161     310.2559      62.4754      52.1810       0.1063       0.1536       3.9432    2635.1221      98.8039      17.2500    4596.0000
 2260.7016     156.1333     186.8602     336.5269     177.1681    1036.2561       0.9650     311.0000       0.0468       0.0121      16.6822      66.5339     311.3485      42.6679      52.1810       0.1311       0.1798       3.8364    2629.9685     161.1647      19.0625    4711.0000
 2260.8540     188.3578     411.3856     415.9285     401.9119     324.0509       3.0859     311.0000       0.0508       0.0163      16.6943      63.8975     311.3485      33.2632      52.1810       0.1449       0.1947       3.8220    2623.1301     158.3296      21.3125    4753.0000
 2261.0064     116.9572     194.0143     170.5481     152.9398     144.7970       6.9062     311.0000       0.0452       0.0105      16.7406      66.1283     310.8022      34.2216      52.1810       0.1190       0.1672       3.8155    2632.6421     156.4140      21.3125    4630.0000
 2261.1588      84.8750      94.1784      93.3062     109.3643      84.5567      11.8264     311.0000       0.0498       0.0153      16.7430      67.0786     310.8022      22.1295      52.1810       0.1133       0.1612       3.7712    2624.7595     159.6198      21.7500    4575.0000
 2261.3112      75.0953      79.7420      83.7530      75.1788      76.8532      13.0118     311.0000       0.0293      -0.0060      16.6857      67.6870     311.8948      40.5016      52.1810       0.1252       0.1739       3.7943    2659.9282     152.4215      21.9375    4563.0000
 2261.4636      70.5783      96.2989      99.8979      89.1122      88.5717      11.2903     311.0000       0.0280      -0.0073      16.7008      72.9599     311.6216      53.7455      52.1810       0.1395       0.1892       3.9017    2662.1228     143.6422      21.9375    4481.0000
 2261.6160      73.6710     118.8642     135.5619      92.0538     116.7617       8.5645     311.0000       0.0383       0.0033      16.6466      74.6089     311.8948      69.1493      52.1810       0.1768       0.2282       4.1154    2644.5005     123.1475      21.9375    4576.0000
 2261.7684      81.8208     101.7462     121.3722     120.1344     106.1786       9.4181     311.0000       0.0563       0.0220      16.5820      76.1539     311.8948      76.3154      52.1810       0.1722       0.2235       4.2568    2613.6777      18.8756      21.9375    4482.0000
 2261.9208      88.1194      87.2010     104.5507     112.5552     107.7401       9.2816     311.0000       0.0603       0.0262      16.5112      69.8671     312.4411      77.6963      52.1810       0.1630       0.2137       4.2409    2606.8105      14.0705      21.9375    4463.0000
 2262.0732     102.9600      73.3235      87.4917     119.1602      74.3189      13.4555     311.0000       0.0361       0.0010      16.5638      70.0922     312.1680      72.5286      52.1810       0.1208       0.1691       4.0447    2648.3101      14.4274      22.8750    4458.0000
 2262.2256     111.1970      83.1759     102.7538     118.9693      97.0481      10.3042     311.0000       0.0241      -0.0114      16.6519      71.7921     311.3485      48.8291      52.1810       0.0826       0.1279       3.7985    2668.7310      57.3844      24.1875    4468.0000
 2262.3780      92.0214     270.0903     280.9838     360.3266     189.1935       5.2856     311.0000       0.0270      -0.0084      16.6640      71.2560     314.6264      23.3839      52.1810       0.0914       0.1374       3.6767    2663.8711     162.7604      24.9375    4599.0000
 2262.5304     126.7765     259.1154     414.6430     476.1230     289.0593       3.4595     311.0000       0.0491       0.0145      16.6178      70.6476     312.9874      14.0991      52.1810       0.1351       0.1842       3.7512    2626.0613     142.1127      25.9375    4631.0000
 2262.6828     129.2008     180.3359     410.5009     503.0345     200.2751       4.9931     311.0000       0.0496       0.0150      16.6381      73.6897     312.9874      31.5702      52.1810       0.1914       0.2433       3.8856    2625.2576      31.9344      26.0000    4714.0000
 2262.8352     122.6651      95.5984     129.3027     176.0397     116.6238       8.5746     311.0000       0.0387       0.0037      16.5457      70.9305     312.9874      54.5402      52.1810       0.1657       0.2161       3.9083    2643.8169      21.2666      26.8125    4694.0000
 2262.9876     136.5636      82.4325     105.9424     135.9003      64.8783      15.4135     311.0000       0.0204      -0.0152      16.5123      63.0212     314.0800      62.8219      52.1810       0.0642       0.1066       3.7609    2675.0764      22.7407      27.3125    4591.0000
 2263.1400     129.5307     111.2844     157.4011     190.8612      98.4630      10.1561     311.0000       0.0295      -0.0058      16.4599      50.8531     317.9043      39.6993      52.1810       0.0306       0.0686       3.5644    2659.4915      96.5669      27.6875    4595.0000
 2263.2924      97.6755     194.1913     207.7561     235.7308     160.4585       6.2321     311.0000       0.0335      -0.0017      16.5519      47.2530     312.4411      26.5784      52.1810       0.0414       0.0804       3.5459    2652.7883     707.5242      26.8750    4583.0000
 2263.4448     115.7569     225.6763     304.4490     322.3729     241.3113       4.1440     311.0000       0.0430       0.0082      16.5883      51.3248     311.8948      23.1547      52.1810       0.0713       0.1140       3.6592    2636.5242     523.1652      28.3125    4466.0000
 2263.5972     137.7337     143.2598     295.4248     284.9366     286.3579       3.4921     311.0000       0.0461       0.0114      16.5299      58.0173     311.8948      29.1405      52.1810       0.1226       0.1701       3.8012    2631.2048      66.1097      28.9375    4475.0000
 2263.7496      84.7468      84.3359     112.1176     108.8916      95.1116      10.5140     311.0000       0.0417       0.0068      16.4990      61.0594     310.8022      39.4657      52.1810       0.1418       0.1909       3.7585    2638.7202      59.7024      29.4375    4496.0000
 2263.9020      78.9952      91.8895     110.9654      99.8493      64.4119      15.5251     311.0000       0.0408       0.0059      16.5069      61.2463     311.8948      32.1169      52.1810       0.1065       0.1535       3.6036    2640.1948      61.7267      29.9375    4447.0000
 2264.0544     119.3206     123.6638     150.7150     160.1511     113.7869       8.7884     311.0000       0.0311      -0.0042      16.4713      62.4181     312.4411      31.0762      52.1810       0.1076       0.1542       3.4697    2656.8857     176.4670      30.9375    4477.0000
 2264.2068     148.7347     181.6584     262.6161     370.7950     268.5959       3.7231     311.0000       0.0399       0.0050      16.4431      58.1592     311.8948      10.7934      52.1810       0.0940       0.1391       3.3995    2641.8059     223.1500      31.6875    4481.0000
 2264.3592     191.1105     253.7086     357.9998     389.7168     269.2656       3.7138     311.0000       0.0398       0.0049      16.4208      55.3200     310.8022       8.8477      52.1810       0.0655       0.1079       3.3778    2641.8735     286.0792      31.6875    4473.0000
 2264.5116     157.6360     229.2422     337.9343     228.0742     204.0782       4.9001     311.0000       0.0455       0.0108      16.3814      51.3090     311.3485       4.2226      52.1810       0.0640       0.1061       3.3687    2632.2097     342.0792      31.6875    4535.0000
 2264.6640     125.3316     195.6574     219.2613     271.2909     155.2639       6.4406     311.0000       0.0352       0.0001      16.4105      56.8216     311.8948      11.9674      52.1810       0.0760       0.1191       3.4076    2649.8250     238.2040      32.1250    4548.0000
 2264.8164     117.2736     161.8040     198.0180     230.7019     181.8675       5.4985     311.0000       0.0275      -0.0078      16.4116      59.6608     311.3485      20.1545      52.1810       0.0853       0.1298       3.4991    2662.9028     188.0776      34.2500    4558.0000
 2264.9688     123.7870     131.4841     160.9880     182.6300     160.0715       6.2472     311.0000       0.0172      -0.0186      16.4380      61.8188     310.8022      30.4191      52.1810       0.1112       0.1581       3.5823    2680.6570     156.1867      35.1875    4553.0000
 2265.1212     111.8390     133.4760     146.4501     131.7837     148.0992       6.7522     311.0000       0.0255      -0.0099      16.4331      65.8380     311.6216      24.0149      52.1810       0.1181       0.1657       3.6000    2666.3335     149.5894      35.6250    4469.0000
 2265.2736     105.8396     103.7147     127.2826     135.3001     135.6990       7.3693     311.0000       0.0290      -0.0063      16.4058      66.0408     311.3485      16.2587      52.1810       0.1124       0.1598       3.5409    2660.3845     161.6730      36.5000    4481.0000
 2265.4260     101.1983     121.9208     121.9244     117.4266     113.0184       8.8481     311.0000       0.0313      -0.0039      16.4662      66.5192     311.3485       5.0862      52.1810       0.1169       0.1644       3.4316    2656.4895     189.6613      37.9375    4503.0000
 2265.5784      78.6744     103.4987      99.6358      96.8981      90.3340      11.0700     311.0000       0.0251      -0.0103      16.4134      66.4418     313.2606       0.1094      52.1810       0.1027       0.1493       3.3247    2666.9954     201.6154      39.4375    4442.0000
 2265.7308      66.2025      77.6372      99.5098     110.9274      99.6767      10.0324     311.0000       0.0179      -0.0178      16.3714      67.4558     310.8022      -2.5330      52.1810       0.0972       0.1435       3.2408    2679.3933     200.3914      41.4375    4505.0000
 2265.8832      54.3895      87.3779      99.7386     112.6106      97.5902      10.2469     311.0000       0.0346      -0.0005      16.3632      67.8398     312.9874       4.2264      52.1810       0.0948       0.1411       3.3799    2650.8577     203.8663      41.4375    4493.0000
 2266.0356      48.1628     105.1009     100.4086     108.6886     100.7865       9.9220     311.0000       0.0977       0.0649      16.3819      68.3228     314.0800      19.6426      52.1810       0.1039       0.1512       3.8436    2542.9392     171.4815      42.4375    4451.0000
 2266.1880      40.8713      53.8675      80.4242     116.6555     102.2385       9.7811     311.0000       0.1529       0.1221      16.3517      73.7985     314.0800      51.8746      52.1810       0.1918       0.2438       4.4275    2448.5042       8.7267      42.9375    4503.0000
 2266.3404      30.0234      24.9463      32.8696      51.9331      50.7053      19.7218     311.0000       0.1445       0.1134      16.3462      77.2677     345.4932      84.5168      52.1810       0.2481       0.3013       4.7104    2462.8213       6.6419      42.8750    4506.0000
 2266.4928      55.1465      39.4552      58.3714      70.1488      59.3289      16.8552     311.0000       0.0770       0.0434      16.3375      78.2047     317.3580      88.5630      52.1810       0.2461       0.2989       4.4831    2578.4146       6.9531      44.8125    4539.0000
 2266.6452      69.4182      78.3800     101.8146     131.0165     130.3802       7.6699     311.0000       0.0168      -0.0190      16.2951      80.0033     314.6264      64.5351      52.1810       0.1816       0.2328       4.0365    2681.3354      37.7252      46.5625    4538.0000
 2266.7976      93.9406     101.2545     222.3902     181.5285     149.8133       6.6750     311.0000       0.0040      -0.0323      16.3076      79.8005     313.5338      28.2102      52.1810       0.1335       0.1829       3.6545    2703.2161     133.1535      47.4375    4548.0000
 2266.9500      75.3709      94.7155     225.9075     376.4134     401.9361       2.4880     311.0000       0.0177      -0.0180      16.3280      79.2595     314.0800       9.4666      52.1810       0.1164       0.1647       3.5260    2679.7131     135.5860      47.6250    4502.0000
 2267.1024      67.6504     128.1233     239.6232     262.2659     169.2132       5.9097     311.0000       0.0279      -0.0075      16.3257      73.7806     314.6264      12.4242      52.1810       0.1383       0.1879       3.5922    2662.3315      94.3462      48.2500    4496.0000
 2267.2548      60.1727     106.0320     112.2902     142.7451     121.5509       8.2270     311.0000       0.0307      -0.0045      16.2900      76.2504     314.6264      27.4332      52.1810       0.1810       0.2324       3.7725    2657.4954      69.7433      49.1250    4483.0000
 2267.4072      52.1775      89.0582      78.0550     100.9501      78.9896      12.6599     311.0000       0.0154      -0.0204      16.2903      77.5129     318.9969      57.4007      52.1810       0.2081       0.2599       3.9364    2683.7122      43.8676      50.0000    4445.0000
 2267.5596      46.8468      56.3083      58.3620      81.2584      52.0595      19.2088     311.0000       0.0188      -0.0169      16.2150      82.1984     316.2654      75.2156      52.1810       0.2099       0.2621       4.0359    2677.9192      35.2050      50.6250    4463.0000
 2267.7120      52.5036      57.3938      62.8768      59.4650      48.5839      20.5830     311.0000       0.0253      -0.0101      16.1650      78.9842     315.9922      83.6155      52.1810       0.1725       0.2237       4.0695    2666.6831      40.7814      49.8125    4485.0000
 2267.8644      57.9538      64.9094      63.7239      68.6382      64.9776      15.3899     311.0000       0.0376       0.0026      16.2311      78.7455     318.9969      83.1177      52.1810       0.1350       0.1844       4.0712    2645.6733      21.1069      49.0000    4495.0000
 2268.0168      60.0574      68.2721      79.8437      82.5629     103.8794       9.6266     311.0000       0.0408       0.0059      16.2872      74.8647     313.5338      83.6501      52.1810       0.1414       0.1912       4.0556    2640.3044      21.5285      47.6875    4494.0000
 2268.1692      87.9526      96.2925     108.5269     120.0413     125.9442       7.9400     311.0000       0.0481       0.0135      16.3054      73.0989     320.0895      82.7875      52.1810       0.1276       0.1765       4.0233    2627.7629      21.4318      46.6875    4576.0000
 2268.3216      87.0720      99.7083     138.6517     162.0336     173.8908       5.7507     311.0000       0.0416       0.0067      16.2194      72.5954     314.6264      90.2169      52.1810       0.1326       0.1816       3.9805    2638.8733      31.1811      45.5625    4535.0000
 2268.4740      64.6073      78.4402      95.1894     131.3308     146.7849       6.8127     311.0000       0.0490       0.0144      16.1694      71.7840     312.9874      65.5036      52.1810       0.1349       0.1839       3.8594    2626.2288      30.3887      44.1250    4517.0000
 2268.6264      82.0322      97.4177     118.4264     159.9899     161.8121       6.1800     311.0000       0.0407       0.0059      16.1844      72.5769     312.9874      42.4056      52.1810       0.1275       0.1761       3.6841    2640.3472      30.1187      42.4375    4549.0000
 2268.7788     113.6685     192.7294     284.4196     279.8110     356.9378       2.8016     311.0000       0.0373       0.0023      16.1128      71.0568     313.8069      19.4278      52.1810       0.0979       0.1444       3.5434    2646.2554     133.3123      41.4375    4475.0000
 2268.9312     107.8930     326.4686     335.2480     355.5212     301.5612       3.3161     311.0000       0.0265      -0.0089      16.1658      70.7323     313.5338      24.2736      52.1810       0.0937       0.1394       3.5045    2664.7307     145.0963      40.8750    4485.0000
 2269.0836     113.1436     226.4622     287.8055     181.6083     365.4969       2.7360     311.0000       0.0323      -0.0029      16.1186      63.9264     312.4411      25.8276      52.1810       0.1078       0.1543       3.5647    2654.7715     144.4251      38.8750    4508.0000
 2269.2360     105.9230     175.5765     182.6026     180.8031     215.8384       4.6331     311.0000       0.0464       0.0118      16.2023      59.1269     312.1680      17.6044      52.1810       0.0869       0.1317       3.6225    2630.5962     185.0080      36.6250    4510.0000
 2269.3884      93.5929     133.1121     163.0249     184.9484     175.8780       5.6858     311.0000       0.0477       0.0131      16.2603      55.7192     311.8948      12.8541      52.1810       0.0856       0.1299       3.6637    2628.4587     189.9606      34.1875    4529.0000
 2269.5408     100.7200     129.7189     150.7056     149.0966     144.4826       6.9212     311.0000       0.0404       0.0055      16.1959      55.5757     311.8948      13.0947      52.1810       0.0735       0.1165       3.6665    2640.8491     220.7845      33.1875    4460.0000
 2269.6932      94.7131     119.5689     125.6309     127.5583     118.3674       8.4483     311.0000       0.0302      -0.0050      16.0834      57.4389     312.9874      19.4807      52.1810       0.0762       0.1195       3.6818    2658.2881     212.5992      31.8750    4497.0000
 2269.8456      81.6323     101.9932     120.0253     110.5572     106.6530       9.3762     311.0000       0.0296      -0.0057      16.0922      56.5783     312.1680      30.0024      52.1810       0.0798       0.1236       3.7371    2659.4236     217.2106      31.6875    4494.0000
 2269.9980      66.4279      87.7274     113.3953     110.0083      91.4750      10.9319     311.0000       0.0343      -0.0008      16.0593      62.0351     312.9874      39.6671      52.1810       0.0803       0.1244       3.8319    2651.3479     222.5228      31.6875    4475.0000
 2270.1504      63.9075      84.1741      94.0182      98.2557      75.6516      13.2185     311.0000       0.0381       0.0031      16.1026      65.1862     312.9874      43.5703      52.1810       0.0947       0.1402       3.8900    2644.9021      29.9718      31.6875    4471.0000
 2270.3028      68.5083      85.6274     102.6909     103.4096      77.4475      12.9120     311.0000       0.0388       0.0039      16.2058      69.3492     313.5338      35.7697      52.1810       0.1272       0.1752       3.8519    2643.5862      28.9365      31.1875    4506.0000
 2270.4552      63.6460      83.8525      91.9650      95.3831      91.5702      10.9206     311.0000       0.0318      -0.0034      16.0858      70.2340     313.8069      34.1246      52.1810       0.1233       0.1715       3.8402    2655.6074      28.2044      30.3750    4495.0000
 2270.6076      58.2546     151.9537     122.9798     130.6564     111.2132       8.9917     311.0000       0.0501       0.0156      16.0786      67.8449     315.1727      33.3362      52.1810       0.0952       0.1419       3.9755    2624.3340     128.3106      28.9375    4536.0000
 2270.7600      74.6161      90.8084     145.9776     133.8233      99.6210      10.0380     311.0000       0.0572       0.0229      16.0141      74.4753     314.6264      56.3214      52.1810       0.1080       0.1556       4.2344    2612.1812      20.0928      27.1250    4529.0000
 2270.9124      43.6340      43.2044      61.8959      77.2637      92.4026      10.8222     311.0000       0.0687       0.0349      16.0943      78.4141     315.9922      74.7795      52.1810       0.2048       0.2571       4.4154    2592.4539      14.5075      26.6250    4528.0000
 2271.0648      38.5218      35.2679      46.5335      52.7393      57.6407      17.3488     311.0000       0.0575       0.0233      16.1309      83.2459     315.1727      78.4016      52.1810       0.2776       0.3310       4.3852    2611.6318      15.0952      25.7500    4534.0000
 2271.2172      57.4131      49.9203      70.1955      75.9170      87.6107      11.4141     311.0000       0.0447       0.0099      16.1402      83.2459     314.0800      56.9718      52.1810       0.1959       0.2475       4.2421    2633.6230      39.2418      25.9375    4484.0000
 2271.3696      77.9570      85.9026     125.4741     150.3622     175.1420       5.7097     311.0000       0.0303      -0.0049      16.0349      83.3088     339.2105      29.8305      52.1810       0.1568       0.2073       4.1037    2658.1409      61.0548      25.5625    4526.0000
 2271.5220      95.6522     106.3857     193.1826     267.3231     233.6845       4.2793     311.0000       0.0188      -0.0169      15.9805      84.0040     313.8069      21.2297      52.1810       0.1348       0.1842       4.0134    2677.8713      63.2473      25.2500    4539.0000
 2271.6744      81.8352     133.6588     248.6061     181.4214     858.7095       1.1645     311.0000       0.0166      -0.0192      16.0152      80.8923     314.6264      32.3215      52.1810       0.1318       0.1807       3.9756    2681.6543     144.2981      25.5625    4544.0000
 2271.8268      77.7359     176.9772     245.1353     181.2225     292.1147       3.4233     311.0000       0.0167      -0.0191      16.1002      76.5313     311.6216      53.1189      52.1810       0.1018       0.1486       3.9750    2681.5217      86.9535      26.1875    4661.0000
 2271.9792      79.2398     145.4738     155.5479     173.8076     167.5415       5.9687     311.0000       0.0221      -0.0135      16.1668      73.3290     311.3485      67.6820      52.1810       0.0904       0.1363       4.0244    2672.1985      45.1882      26.4375    4630.0000
 2272.1316      70.7661     102.1797     113.5073     152.6952     109.6286       9.1217     311.0000       0.0235      -0.0120      15.9943      70.1862     311.8948      71.9864      52.1810       0.1465       0.1960       4.0381    2669.7620      22.0877      26.5625    4599.0000
 2272.2840      85.2374      86.1623     101.7426     151.5288      89.4409      11.1806     311.0000       0.0205      -0.0151      15.9570      72.0244     311.6216      73.2067      52.1810       0.1397       0.1890       3.9982    2674.9272      32.1101      26.4375    4574.0000
 2272.4364      86.9458      93.4045     116.5587     143.7088      96.9100      10.3189     311.0000       0.0067      -0.0294      15.9273      73.3344     311.3485      71.0590      52.1810       0.1190       0.1670       3.9039    2698.4705      27.6866      26.4375    4523.0000
 2272.5888      98.8653     116.7469     139.5025     160.4261     135.1530       7.3990     311.0000       0.0161      -0.0196      15.9278      72.3498     310.8022      60.8995      52.1810       0.1123       0.1598       3.8488    2682.4180      72.2236      26.1875    4526.0000
 2272.7412     101.1157     163.0444     182.9101     204.1365     165.0474       6.0589     311.0000       0.0204      -0.0153      15.9716      69.2253     311.8948      59.3071      52.1810       0.0900       0.1355       3.8599    2675.1895      76.3678      25.8750    4583.0000
 2272.8936      88.4073     126.5304     156.6486     163.9342     170.4824       5.8657     311.0000       0.0298      -0.0054      15.9287      65.8609     310.8022      54.7736      52.1810       0.1090       0.1558       3.8722    2658.9756      40.6819      25.4375    4514.0000
 2273.0460      86.0528     109.6650     124.7036     132.1374     161.5751       6.1891     311.0000       0.0165      -0.0193      15.9719      64.7900     320.0895      47.8387      52.1810       0.0977       0.1434       3.7979    2681.7876      40.6554      24.9375    4525.0000
 2273.1984      96.5521     136.0723     160.4086     159.7280     174.8715       5.7185     311.0000       0.0223      -0.0133      15.9654      63.5894     309.7096      24.9016      52.1810       0.0855       0.1305       3.6381    2671.9167      42.5610      24.5000    4580.0000
 2273.3508      88.1307     145.2494     160.1629     159.9706     187.4050       5.3360     311.0000       0.0370       0.0020      15.9529      64.5738     311.8948       9.3298      52.1810       0.0947       0.1403       3.5557    2646.6946     247.9147      22.7500    4552.0000
 2273.5032      83.4394     206.5366     205.2652     210.4088     204.8689       4.8812     311.0000       0.0446       0.0099      15.9161      66.7260     311.8948      30.1709      52.1810       0.0904       0.1361       3.6778    2633.6853     209.6459      21.9375    4582.0000
 2273.6556      79.7202     132.6318     183.8450     222.3432     229.3266       4.3606     311.0000       0.0311      -0.0041      15.9150      70.7930     311.3485      67.0047      52.1810       0.1187       0.1668       3.8906    2656.7368      59.8488      21.9375    4555.0000
 2273.8080      70.4853      88.0890     117.7502     134.8606     132.1933       7.5647     311.0000       0.0129      -0.0230      15.9141      72.0912     311.8948      97.5187      52.1810       0.1788       0.2302       4.0289    2687.8904      28.2299      20.4375    4559.0000
 2273.9604      85.8582      90.5189     115.9410     130.0353     109.7800       9.1091     311.0000       0.0090      -0.0270      15.8657      72.7400     312.9874      84.5590      52.1810       0.1668       0.2177       3.9501    2694.5337      28.7215      18.6875    4563.0000
 2274.1128     110.8594     113.9211     178.6641     204.7263     187.8327       5.3239     311.0000       0.0145      -0.0214      15.9173      69.8735     312.9874      56.2925      52.1810       0.1038       0.1505       3.7742    2685.2617      43.5155      17.4375    4508.0000
 2274.2652     132.6361     185.7865     267.8436     306.2816     304.7957       3.2809     311.0000       0.0096      -0.0265      15.9177      63.8065     316.2654      34.9288      52.1810       0.0767       0.1202       3.5866    2693.6431     120.3493      16.0625    4573.0000
 2274.4176     147.0682     229.1169     300.2826     404.8803     496.0361       2.0160     311.0000       0.0077      -0.0284      15.8917      58.1928     311.3485      25.7010      52.1810       0.0670       0.1085       3.4497    2696.8777     121.5036      13.8125    4552.0000
 2274.5700     167.1641     299.3775     335.6157     380.3945     602.1268       1.6608     311.0000       0.0081      -0.0280      15.8566      55.4784     311.3485      15.9605      52.1810       0.0535       0.0935       3.3649    2696.1851     125.2541      13.4375    4542.0000
 2274.7224     175.0307     348.1166     602.7999     462.7145     463.8469       2.1559     311.0000       0.0153      -0.0205      15.8312      55.1628     310.8022       4.3340      52.1810       0.0529       0.0924       3.3547    2683.8459     296.3322      12.2500    4543.0000
 2274.8748     156.5802     617.3731     861.0760    1065.8993     622.2977       1.6069     311.0000       0.0196      -0.0160      15.8364      56.3432     309.1632      -1.5049      52.1810       0.0545       0.0942       3.4349    2676.4692     395.2516      12.4375    4484.0000
 2275.0272     124.7072     404.2628     308.5993     251.3864     287.9984       3.4722     311.0000       0.0273      -0.0081      15.8830      56.0285     309.7096      -1.6534      52.1810       0.0449       0.0842       3.5417    2663.3135     527.1017      12.6250    4498.0000
 2275.1796     119.6318     155.7682     198.3521     169.9006     181.9311       5.4966     311.0000       0.0347      -0.0004      15.9406      62.1830     309.7096       2.0866      52.1810       0.0549       0.0953       3.6364    2650.6494     467.8691      12.7500    4532.0000
 2275.3320      89.8982      92.1238     118.2545     101.0619     108.5413       9.2131     311.0000       0.0467       0.0120      15.8782      67.2771     309.1632       3.9129      52.1810       0.0900       0.1341       3.6900    2630.1523     108.4636      12.8125    4529.0000
 2275.4844      77.2071      83.3158      96.4991      70.4180      86.8798      11.5102     311.0000       0.0515       0.0170      15.8126      71.8088     309.1632       7.0622      52.1810       0.1085       0.1546       3.6976    2621.8789      99.3192      13.0625    4585.0000
 2275.6368      86.0534      85.4591      92.2110      83.0758      92.2967      10.8346     311.0000       0.0532       0.0188      15.8159      70.5225     309.1632       7.9331      52.1810       0.0929       0.1384       3.6797    2618.9607      80.2334      13.5625    4549.0000
 2275.7892      90.5123     125.5756     106.7737     111.8295     106.1934       9.4168     311.0000       0.0489       0.0144      15.8310      72.7810     311.3485       7.8053      52.1810       0.0852       0.1304       3.6219    2626.3062     141.1427      14.0625    4576.0000
 2275.9416      98.3332     132.7653     102.9712      90.2353      85.6149      11.6802     311.0000       0.0455       0.0107      15.8333      75.0648     307.2511       5.6534      52.1810       0.1125       0.1598       3.5594    2632.2681     130.0614      14.3750    4569.0000
 2276.0940      95.0300     151.7923     186.5126     146.1245     109.9573       9.0944     311.0000       0.0512       0.0167      15.7868      77.3243     308.8901      17.1771      52.1810       0.1186       0.1667       3.6974    2622.4526     121.2089      14.4375    4605.0000
 2276.2464      86.8458     228.4054     184.9983     184.0627     176.1028       5.6785     311.0000       0.1168       0.0847      15.8433      73.9839     316.2654      35.8980      52.1810       0.1280       0.1766       4.1090    2510.2942      81.0975      14.5625    4531.0000
 2276.3988      96.5306     116.1084     199.6847     157.0276     173.9644       5.7483     311.0000       0.2064       0.1776      15.8191      69.7037     312.1680      58.5055      52.1810       0.1177       0.1658       4.6896    2356.9961      10.6868      14.6875    4647.0000
 2276.5512      53.3092      54.4033      78.5498      97.7330      70.4571      14.1930     311.0000       0.2119       0.1833      15.7570      70.5687     311.8948     103.6282      52.1810       0.1258       0.1744       4.9709    2347.6353       7.1520      14.4375    4519.0000
 2276.7036      53.3620      51.9464      71.9930      70.4766      71.5658      13.9732     311.0000       0.1279       0.0962      15.7417      72.1914     311.8948     133.0783      52.1810       0.1892       0.2409       4.7927    2491.2063       7.7892      14.0000    4494.0000
 2276.8560      92.9053      88.5756     146.7037     105.5164     182.1949       5.4886     311.0000       0.0307      -0.0046      15.7007      73.8635     314.3532     138.3476      52.1810       0.1559       0.2056       4.3798    2657.5659      26.4616      14.1875    4517.0000
 2277.0084     135.2058     163.9303     297.1063     283.6628     301.1178       3.3210     311.0000       0.0161      -0.0197      15.7633      69.3326     343.8542      88.8593      52.1810       0.0572       0.0994       4.0488    2682.4673     127.5605      14.3750    4501.0000
 2277.1608     159.5843     257.5822     427.9314     315.7756     389.4498       2.5677     311.0000       0.0274      -0.0080      15.7693      64.5626     350.6832      52.0687      52.1810       0.0564       0.0978       3.9484    2663.1992     159.6039      14.8125    4514.0000
 2277.3132      93.5840     205.7243     269.8229     196.8883     178.6011       5.5991     311.0000       0.0623       0.0282      15.7306      61.1126     318.9969      29.9914      52.1810       0.0715       0.1148       3.9699    2603.5088     178.8264      15.2500    4544.0000
 2277.4656      60.2689     117.3975     162.5685     170.6555     128.8096       7.7634     311.0000       0.1040       0.0714      15.7996      62.3997     308.8901      39.7077      52.1810       0.0837       0.1289       4.2166    2532.2266      22.1106      16.0625    4582.0000
 2277.6180      69.8321     103.2520     128.4781     201.6013     105.7319       9.4579     311.0000       0.1233       0.0914      15.6471      65.4545     303.5180      81.7282      52.1810       0.1363       0.1852       4.5698    2499.1494      12.4609      16.1250    4609.0000
 2277.7704     106.1952     206.0562     213.2930     271.5592     175.3759       5.7020     311.0000       0.1353       0.1039      15.5837      71.9454     301.5148     121.8724      52.1810       0.1342       0.1828       4.9959    2478.5872      12.1483      16.8750    4595.0000
 2277.9228     130.3430     111.9459     170.8337     166.6167     118.0029       8.4744     311.0000       0.1358       0.1044      15.6982      71.8373     332.9279     143.8413      52.1810       0.0877       0.1321       5.2282    2477.7537      14.0603      16.9375    4533.0000
 2278.0752      78.7870      77.9915     109.0709     138.9225      85.7871      11.6568     311.0000       0.1380       0.1066      15.7345      72.3039     319.2701     145.1738      52.1810       0.0890       0.1334       5.3002    2474.0464      12.8464      15.0625    4494.0000
 2278.2276      60.5662      59.3413      75.5813     115.7415      61.5017      16.2597     311.0000       0.1137       0.0814      15.7727      66.8948     329.9232     162.0288      52.1810       0.0990       0.1450       5.2872    2515.6519      12.2639      15.1875    4460.0000
 2278.3800      73.7579      83.2828      76.9243      84.8049      61.8048      16.1800     311.0000       0.0938       0.0609      15.6935      67.3273     335.0222     195.2226      52.1810       0.1034       0.1498       5.3547    2549.5442      21.1656      15.6250    4505.0000
 2278.5324      71.9203      92.9427     127.5461      89.8721      65.5140      15.2639     311.0000       0.1308       0.0992      15.6471      68.6840     335.0222     203.0797      52.1810       0.0845       0.1300       5.5755    2486.2788       8.2463      15.5000    4503.0000
 2278.6848      50.2375     127.4809      90.1615     145.9316     123.5085       8.0966     311.0000       0.1807       0.1509      15.6587      70.5116     354.2342     208.0135      52.1810       0.0944       0.1406       5.8923    2400.9526       5.9807      14.4375    4538.0000
 2278.8372      54.5446      60.3475      83.7828     105.8990      63.0431      15.8622     311.0000       0.2888       0.2630      15.6437      74.9583     355.3268     176.0392      52.1810       0.1190       0.1674       6.3562    2216.1208       3.7509      14.2500    4557.0000
 2278.9896      27.7876      36.1259      31.1902      41.3684      51.9578      19.2464     311.0000       0.3536       0.3301      15.6204      75.8109     335.2042     152.8889      52.1810       0.2083       0.2607       6.7856    2105.2893       3.0389      12.1250    4541.0000
 2279.1420      27.4837      16.0326      18.2259      27.8504      17.9914      55.5822     311.0000       0.3403       0.3163      15.6874      81.7724     340.3032     130.8609      52.1810       0.3125       0.3654       6.8760    2128.1199       3.2019      12.1250    4615.0000
 2279.2944      40.2722      30.6494      45.7368      63.0791      31.1444      32.1085     311.0000       0.2534       0.2262      15.5661      82.9483     354.5074     127.2314      52.1810       0.2851       0.3372       6.4946    2276.7585       4.9797      12.1250    4597.0000
 2279.4468      76.3126      75.4266      81.5837      98.6137      81.4771      12.2734     311.0000       0.2777       0.2514      15.4487      85.4353     312.0769      94.4617      52.1810       0.2099       0.2604       6.1606    2235.2148       7.6456      12.1250    4551.0000
 2279.5992      54.0214     127.2849     236.7112     353.3666     171.2073       5.8409     311.0000       0.3777       0.3551      15.6371      84.6780     312.9874      63.3585      52.1810       0.1833       0.2338       6.2057    2064.1624       4.1142      11.4375    4585.0000
 2279.7516      77.6262     196.7345     673.2050     750.2372     565.7566       1.7675     311.0000       0.4404       0.4200      15.6464      81.6504     318.2685      54.0470      52.1810       0.2071       0.2583       6.2874    1956.9376       3.1997      10.5625    4584.0000
 2279.9040      80.3207     189.9859     317.4400     333.3716     234.3224       4.2676     311.0000       0.3978       0.3759      15.6608      80.0418     338.9374      49.1687      52.1810       0.2489       0.3014       6.0900    2029.7463       3.0904       8.8750    4507.0000
 2280.0564     105.9579     148.7269     245.5618     194.3829     193.3636       5.1716     311.0000       0.3164       0.2915      15.6255      74.7295     379.9110      34.1372      52.1810       0.2357       0.2889       5.5097    2169.0374       3.5620       6.9375    4614.0000
 2280.2088     127.6418     192.6421     534.7789     503.6402     314.6832       3.1778     311.0000       0.2321       0.2042      15.5860      71.3884     386.4668      26.3824      52.1810       0.1319       0.1806       4.9471    2313.1262       4.6054       4.8125    4540.0000
 2280.3612     155.9121     354.6598     861.7178     722.8093     718.6514       1.3915     311.0000       0.1498       0.1189      15.5849      61.8599     395.2078      51.7302      52.1810       0.0540       0.0953       4.4868    2453.7622       8.5860       3.1875    4511.0000
 2280.5136     132.9009     448.6253     808.0193     662.4073     629.8159       1.5878     311.0000       0.1117       0.0794      15.5392      58.9504     387.0131      91.2340      52.1810       0.0420       0.0807       4.3565    2518.9324      17.8580       2.7500    4522.0000
 2280.6660     131.1274     379.7156     515.1003     504.6885     395.4565       2.5287     311.0000       0.1214       0.0894      15.5204      54.7226     375.2673     131.9728      52.1810       0.0458       0.0839       4.5201    2502.4597      15.7077       2.3750    4497.0000
 2280.8184     131.1833     502.5416     352.7545     287.5345     267.8084       3.7340     311.0000       0.1275       0.0957      15.4907      54.2984     335.9327     170.6622      52.1810       0.0501       0.0892       4.7713    2492.0500       8.4622       2.3750    4532.0000
 2280.9708     144.8143     469.6054     750.5252     525.2067     212.4915       4.7061     311.0000       0.1034       0.0708      15.4914      56.3428     353.9611     183.4149      52.1810       0.0494       0.0887       4.8321    2533.1387       7.4477       2.3750    4493.0000
 2281.1232     139.8909     622.8984     268.9039     222.3817     182.0100       5.4942     311.0000       0.0750       0.0413      15.4779      62.3016     363.7947     160.9030      52.1810       0.0582       0.0987       4.6668    2581.7898       8.9784       2.3750    4474.0000
 2281.2756     119.0715     163.4292     191.2838     161.6003     132.3810       7.5540     311.0000       0.0343      -0.0008      15.4498      70.9435     325.1885     146.4574      52.1810       0.0737       0.1162       4.4240    2651.3091      18.7543       2.0625    4531.0000
 2281.4280     127.3184     183.6936     131.7447     114.2882      90.0737      11.1020     311.0000       0.0031      -0.0332      15.4650      70.8463     313.3517     156.0945      52.1810       0.0834       0.1272       4.2949    2704.7729      37.4927       2.0625    4517.0000
 2281.5804     120.7700     152.1648     118.7367     102.9710      84.2161      11.8742     311.0000      -0.0273      -0.0646      15.4287      70.8345     310.8022     189.9912      52.1810       0.0877       0.1323       4.3202    2756.6580     177.6043       0.8750    4526.0000
 2281.7328      92.3436     126.4771     109.8438      90.2177      80.3709      12.4423     311.0000      -0.0330      -0.0706      15.4230      66.7363     310.2559     204.0977      52.1810       0.0889       0.1343       4.4086    2766.4368     183.7645       1.6875    4563.0000
 2281.8852     105.4295     164.4894     166.4332     138.6177     109.8504       9.1033     311.0000      -0.0114      -0.0481      15.3877      66.9416     309.8917     186.0282      52.1810       0.1203       0.1684       4.4610    2729.4377      63.0964       2.3750    4496.0000
 2282.0376     112.8104     162.2457     206.8579     166.9889     130.2442       7.6779     311.0000       0.0286      -0.0068      15.3928      69.1170     309.5274     140.8083      52.1810       0.1420       0.1916       4.4023    2661.1650      25.6907       2.3750    4476.0000
 2282.1900     158.0321     151.3996     252.8361     202.2928     141.6897       7.0577     311.0000       0.0528       0.0184      15.4173      72.0258     307.7064     103.5199      52.1810       0.1354       0.1844       4.2617    2619.6555      20.4451       2.3750    4530.0000
 2282.3424     144.9574     146.7919     300.2486     217.7621     133.9898       7.4633     311.0000       0.0549       0.0206      15.3897      75.4987     307.5243      91.4388      52.1810       0.1251       0.1735       4.1248    2616.0642      28.2723       2.3750    4447.0000
 2282.4948     123.9017     147.9592     309.5790     238.5873     139.6136       7.1626     311.0000       0.0356       0.0006      15.4210      77.5403     306.9780     100.9872      52.1810       0.0999       0.1464       4.0614    2649.0815      57.6485       2.3750    4477.0000
 2282.6472     113.3362     165.4300     228.7618     242.3233     119.7379       8.3516     311.0000       0.0226      -0.0130      15.3708      77.8769     304.0643     106.0524      52.1810       0.0931       0.1390       4.0295    2671.3899     105.7972       2.8125    4539.0000
 2282.7996     111.4591     132.4966     261.2158     213.9115     113.7006       8.7950     311.0000       0.0185      -0.0172      15.3566      77.2153     306.6138      98.0308      52.1810       0.1027       0.1492       3.9767    2678.3218      97.4749       3.6250    4576.0000
 2282.9520     112.4326     118.9353     281.2552     206.6118     122.9434       8.1338     311.0000       0.0364       0.0013      15.3731      75.2819     306.4317      76.2029      52.1810       0.1225       0.1702       3.9172    2647.8374      89.7770       5.6875    4599.0000
 2283.1044     122.3567     163.9005     265.7973     267.3967     121.9430       8.2006     311.0000       0.0507       0.0162      15.3450      77.8648     306.9780      68.5318      52.1810       0.1017       0.1480       3.9257    2623.2644      84.2514       8.5000    4590.0000
 2283.2568     114.4047     133.6255     212.7582     224.1141      89.3130      11.1966     311.0000       0.0574       0.0231      15.3660      77.3363     306.0675      70.8852      52.1810       0.0837       0.1281       3.9795    2611.9041      69.2246      12.1250    4614.0000
 2283.4092      96.8163      91.1378     130.8217     200.5003      65.5533      15.2548     311.0000       0.0487       0.0141      15.3723      73.6471     304.9748      75.2389      52.1810       0.0879       0.1324       3.9953    2626.7500      61.8918      13.5625    4638.0000
 2283.5616      85.5118      97.8663     147.1843     171.5682      79.8428      12.5246     311.0000       0.0424       0.0076      15.3309      73.2657     305.3391      69.5782      52.1810       0.0782       0.1216       3.9460    2637.4871      68.0715      19.5625    4669.0000
 2283.7140      81.7000     114.3729     151.6441     145.9699      79.1734      12.6305     311.0000       0.0385       0.0035      15.3298      69.2630     305.8853      53.6621      52.1810       0.0727       0.1157       3.8838    2644.1628      91.5652      21.9375    4625.0000
 2283.8664      79.4966     137.1238     162.7476     191.5772     161.7611       6.1820     311.0000       0.0436       0.0089      15.2866      70.5605     306.4317      44.3978      52.1810       0.0766       0.1197       3.9130    2635.3660     114.8675      21.9375    4490.0000
 2284.0188      77.3699      58.8050     142.0924     146.9951     123.4091       8.1031     311.0000       0.0818       0.0484      15.3951      68.3590     306.6138      45.3343      52.1810       0.0645       0.1072       4.1594    2570.0867      85.6217      21.9375    4498.0000
 2284.1712      37.2671      39.2269      62.4541      65.9221      68.4012      14.6196     311.0000       0.1400       0.1087      15.3792      78.1885     311.5306      61.3203      52.1810       0.0959       0.1424       4.5991    2470.5938      32.1305      25.5625    4514.0000
 2284.3236      21.2364      22.5669      32.9048      40.6254      49.1520      20.3451     311.0000       0.1704       0.1402      15.3986      83.5011     316.9937      86.3211      52.1810       0.2340       0.2868       4.9969    2418.6438       7.2856      28.0000    4526.0000
 2284.4760      25.3325      25.8536      41.7305      56.3255      77.7123      12.8680     311.0000       0.1485       0.1176      15.3101      91.9228     337.0253      99.1476      52.1810       0.3403       0.3906       5.0499    2456.0293       5.7573      29.6875    4542.0000
 2284.6284      41.1925      39.8156      69.4102      98.8748     125.2663       7.9830     311.0000       0.0957       0.0628      15.3349      90.1408     320.6359     104.8813      52.1810       0.2097       0.2606       4.7902    2546.4067       7.1312      31.0000    4466.0000
 2284.7808      54.7531      60.6551     132.4430     145.9642     179.9987       5.5556     311.0000       0.0722       0.0385      15.3331      91.8565     315.1727     113.0672      52.1810       0.1828       0.2339       4.5766    2586.5396      13.9516      31.6875    4566.0000
 2284.9332      74.9095      61.8194     175.5672     309.3535     390.0401       2.5638     311.0000       0.0802       0.0467      15.2898      90.0339     315.7190     125.4334      52.1810       0.1887       0.2405       4.5877    2572.9368      18.2769      31.6875    4519.0000
 2285.0856      76.8420      77.7124     122.9864     340.8996     351.1904       2.8475     311.0000       0.0859       0.0526      15.3503      95.6003     314.3532     131.8648      52.1810       0.1694       0.2205       4.6679    2563.1934       8.2750      33.0625    4573.0000
 2285.2380      92.2823      93.1499     119.6886     415.9697     352.5896       2.8362     311.0000       0.0679       0.0340      15.3528      97.0219     316.2654     120.1229      52.1810       0.1810       0.2324       4.5749    2593.9609       9.9559      34.8750    4557.0000
 2285.3904     152.2528     122.7354     144.0050     322.4077     165.5758       6.0395     311.0000       0.0438       0.0090      15.3236      94.5194     328.8306      91.8572      52.1810       0.2161       0.2688       4.3052    2635.1821      11.3342      36.0000    4499.0000
 2285.5428     347.8067     194.4755     241.1287     292.9847     598.0150       1.6722     311.0000       0.0385       0.0035      15.3224      93.2383     312.7143      72.2752      52.1810       0.1433       0.1932       4.1039    2644.1885      47.7541      37.6250    4477.0000
 2285.6952     127.9507     243.5554     117.1278     100.9317     123.1921       8.1174     311.0000       0.0530       0.0186      15.2857      93.4386     307.1601      60.6656      52.1810       0.1057       0.1533       4.0940    2619.3347      31.3141      39.6875    4539.0000
 2285.8476     233.2296     128.6203     111.0850      60.9289      83.1654      12.0242     311.0000       0.0546       0.0202      15.2971      95.4001     318.1774      71.1572      52.1810       0.1268       0.1756       4.2521    2616.6655      27.4072      41.4375    4544.0000
 2286.0000     210.8517     128.7724      66.3148      37.9346      55.6863      17.9577     311.0000       0.0465       0.0118      15.3090      93.0050     307.2511      84.6052      52.1810       0.1618       0.2125       4.4427    2630.5127      25.2009      41.4375    4444.0000
 2286.1524     153.5327     140.0733      58.9146      33.9824      52.8479      18.9222     311.0000       0.0520       0.0175      15.2455      88.1528     314.3532      95.9990      52.1810       0.1479       0.1979       4.6292    2621.1006      47.1401      41.4375    4440.0000
 2286.3048     107.6907     103.5250      70.5913      32.5868      44.9165      22.2635     311.0000       0.0716       0.0378      15.3144      89.7898     319.8164     101.8999      52.1810       0.1265       0.1754       4.7815    2587.5815      18.6449      41.5625    4434.0000
 2286.4572     108.7257      73.8844      87.3701      37.7097      48.4964      20.6201     311.0000       0.0802       0.0467      15.3700      94.7468     326.0990     105.5996      52.1810       0.1339       0.1831       4.8237    2572.8650      13.4630      42.8125    4566.0000
 2286.6096      50.5722      49.9566      38.3674      28.5983      40.4240      24.7378     311.0000       0.0710       0.0372      15.2823     100.1396     312.7143     111.7973      52.1810       0.1354       0.1847       4.7775    2588.5640      12.4319      43.1250    4733.0000
 2286.7620      35.1242      30.3091      32.8140      27.2867      32.3392      30.9222     311.0000       0.0755       0.0419      15.3290      99.0435     314.2622     129.8714      52.1810       0.1398       0.1893       4.8699    2580.9153      26.0958      42.7500    4673.0000
 2286.9144      37.6656      25.8710      37.1956      47.3675      50.5047      19.8002     311.0000       0.0915       0.0584      15.3621      98.9522     306.9780     174.4225      52.1810       0.1335       0.1826       5.2062    2553.5952      20.2369      42.8750    4587.0000
 2287.0668      38.7238      21.6338      32.6058      52.5582      54.8906      18.2181     311.0000       0.1421       0.1109      15.3344      98.3195     332.3816     204.3383      52.1810       0.1099       0.1573       5.7011    2467.0266       6.5959      42.0000    4572.0000
 2287.2192      41.8071      19.8115      30.5301      83.1990      61.8349      16.1721     311.0000       0.1793       0.1495      15.3483     100.7909     362.4290     209.7125      52.1810       0.1115       0.1589       6.0325    2403.3779       4.3921      41.4375    4501.0000
 2287.3716      43.2850      28.2068      47.0498     109.4974      81.0651      12.3358     311.0000       0.2045       0.1755      15.3311     100.1594     361.0632     182.4524      52.1810       0.1255       0.1740       6.0830    2360.3630       3.5876      40.7500    4583.0000
 2287.5240      56.3556      58.2661      68.9660     170.9799     119.9393       8.3376     311.0000       0.1818       0.1520      15.3523     102.3060     316.2654     165.0524      52.1810       0.1344       0.1836       5.8822    2399.1917       4.6012      39.9375    4637.0000
 2287.6764      45.2818      67.0247     145.1642     181.4517     144.6634       6.9126     311.0000       0.1812       0.1514      15.3471      97.9955     310.8022     147.7859      52.1810       0.1236       0.1722       5.6594    2400.1191       4.8268      39.1250    4538.0000
 2287.8288      38.5191      70.6976      68.9956     180.9361     161.0061       6.2109     311.0000       0.1591       0.1286      15.3314      91.5987     311.3485     158.8941      52.1810       0.1363       0.1855       5.5078    2437.8538       4.5185      38.3125    4436.0000
 2287.9812      48.1379      66.4325      77.8478     141.6974     121.5992       8.2237     311.0000       0.1432       0.1121      15.3628      91.6157     321.1822     172.9770      52.1810       0.1320       0.1810       5.4236    2465.0491       6.0493      35.1250    4515.0000
 2288.1336      67.4157     122.8241     112.3364     142.6505     150.0795       6.6631     311.0000       0.1135       0.0813      15.3867      94.4345     309.5274     189.2312      52.1810       0.1296       0.1786       5.3651    2515.9019       6.9773      32.0000    4699.0000
 2288.2860      58.1686     147.7497     154.2249     202.7194     167.6618       5.9644     311.0000       0.1366       0.1052      15.4137      98.0532     312.9874     168.3621      52.1810       0.1301       0.1791       5.3566    2476.3906       7.3825      31.3750    4801.0000
 2288.4384      43.6276      93.2462     160.1132     140.1016     171.5019       5.8308     311.0000       0.1698       0.1396      15.4321      93.5784     322.2748     130.1882      52.1810       0.1242       0.1727       5.3627    2419.6584       7.1460      30.3750    4672.0000
 2288.5908      31.7846      40.3014      55.4845      71.0688      85.7750      11.6584     311.0000       0.1719       0.1418      15.4419      94.2018     340.0300      90.8127      52.1810       0.1217       0.1698       5.2504    2415.9946       4.6961      29.6250    4585.0000
 2288.7432      41.0673      34.2663      42.1324      40.9352      56.9916      17.5464     311.0000       0.1421       0.1109      15.4500      94.4231     317.9043      64.1046      52.1810       0.1288       0.1775       5.0384    2466.9729       5.6571      27.8750    4466.0000
 2288.8956      76.0547      87.3032     127.3971     124.2362     179.7739       5.5625     311.0000       0.0884       0.0553      15.4556      96.2201     345.4932      60.0944      52.1810       0.1100       0.1575       4.8224    2558.8298       5.5952      27.0000    4478.0000
 2289.0480     117.2055     132.1712     195.0078     183.5934     261.2028       3.8284     311.0000       0.0524       0.0180      15.4618      93.1126     311.5306      62.6040      52.1810       0.1287       0.1775       4.7578    2620.3530      14.1137      24.8125    4524.0000
 2289.2004     147.3368     278.7252     438.7610     398.0810     635.7559       1.5729     311.0000       0.0335      -0.0016      15.4685      92.5588     315.1727      63.9088      52.1810       0.1300       0.1789       4.7890    2652.6443      28.2306      22.5000    4482.0000
 2289.3528      83.6152     378.2542     275.5253     250.9453     199.9808       5.0005     311.0000       0.0225      -0.0131      15.4739      93.8180     307.1601      70.3657      52.1810       0.1269       0.1757       4.8478    2671.5781     145.4344      21.9375    4540.0000
 2289.5052      72.9918     132.3741     101.8219      93.0737     104.6885       9.5521     311.0000       0.0232      -0.0123      15.4755      97.2334     306.9780      77.8217      52.1810       0.1417       0.1912       4.8613    2670.3162     142.8116      21.9375    4534.0000
 2289.6576      86.3265     170.6772     121.9979     117.7964     106.9871       9.3469     311.0000       0.0264      -0.0090      15.4822      94.6217     304.7927      93.5159      52.1810       0.1375       0.1869       5.0783    2664.9216     126.5611      21.0000    4444.0000
 2289.8100      96.9327     170.8955     113.6681     118.7002      95.0428      10.5216     311.0000       0.0556       0.0213      15.4852      91.8641     303.4269     101.0563      52.1810       0.1200       0.1683       5.6547    2614.9158      88.2862      19.7500    4456.0000
 2289.9624      86.3668     150.6746     129.0960     120.3405      96.1306      10.4025     311.0000       0.0784       0.0449      15.4889      90.2168     308.0706     120.1434      52.1810       0.1190       0.1672       6.5083    2575.9814      58.7049      17.2500    4450.0000
 2290.1148     116.6875     151.9251     150.9874     133.7672     101.0925       9.8919     311.0000       0.0829       0.0495   -5612.1274      89.4020     300.4222     157.1570      52.1810       0.1434       0.1931       7.2372    2568.3247      35.5015      15.7500    4412.0000
 2290.2672     121.3104     175.4409     168.2631     142.2532     112.6796       8.8747     311.0000       0.0709       0.0371    -999.2500      91.5808     297.9638     206.3212      52.1810       0.1333       0.1826       7.6165    2588.7717      28.6779      14.3750    4465.0000
 2290.4196     102.8498     164.5637     192.3048     171.5887     140.8571       7.0994     311.0000       0.0507       0.0161    -999.2500      89.3909     298.0548     254.8227      52.1810       0.1514       0.2017       7.7128    2623.3540      23.9704      13.1250    4476.0000
 2290.5720     109.2034     161.5387     195.7196     179.9593     149.5359       6.6874     311.0000       0.0434       0.0086    -999.2500      90.4317     297.5085     278.8160      52.1810       0.1559       0.2064       7.7026    2635.8293      22.5221      12.8125    4512.0000
 2290.7244     112.9786     170.2235     200.5407     210.8152     212.6187       4.7033     311.0000       0.0398       0.0048    -999.2500      87.3655     296.4159     289.8331      52.1810       0.1494       0.1995       7.6856    2642.0168      20.9062      12.1250    4567.0000
 2290.8768     124.6494     203.9830     226.0858     276.5678     320.3666       3.1214     311.0000       0.0400       0.0051    -999.2500      87.3655     296.5980     294.7545      52.1810       0.1353       0.1846       7.6957    2641.5295      20.3744      12.1250    4654.0000
 2291.0292     135.0890     221.6682     247.6480     455.3230     488.6775       2.0463     311.0000       0.0418       0.0070    -999.2500      87.3655     296.5980     296.1111      52.1810       0.1250       0.1737       7.7006    2638.4888      20.0484      12.1250    4582.0000
 2291.1816     146.1409     214.2262     223.2152     232.3683     293.1259       3.4115     311.0000       0.0442       0.0094    -999.2500      87.3655     296.0517     292.5139      52.1810       0.1301       0.1791       7.6885    2634.4326      20.1336      12.1250    4601.0000
 2291.3340     153.6120     193.1745     207.9699     190.4258     237.2349       4.2152     311.0000       0.0455       0.0108    -999.2500      87.3655     296.3248     289.5942      52.1810       0.1401       0.1897       7.6556    2632.1824      20.1001      12.1250    4541.0000
 2291.4864     147.7919     165.5741     186.6018     163.3292     177.4332       5.6359     311.0000       0.0473       0.0126    -999.2500      87.3655     296.0517     287.6177      52.1810       0.1387       0.1882       7.6355    2629.1426      20.4016      12.1250    4495.0000
 2291.6388     127.7147     152.6052     165.1966     146.2930     127.9710       7.8143     311.0000       0.0477       0.0131    -999.2500      87.3655     296.4159     287.1997      52.1810       0.1342       0.1834       7.6256    2628.3647      20.4278      11.5625    4475.0000
 2291.7912     115.7289     135.0780     151.3941     125.3123     113.7518       8.7911     311.0000       0.0477       0.0131    -999.2500      87.3655     296.5980     287.6732      52.1810       0.1420       0.1917       7.6307    2628.4446      20.0847      12.1250    4479.0000
 2291.9436      96.0644     112.3511     122.0832     120.5024      87.6575      11.4080     311.0000       0.0481       0.0134    -999.2500      87.3655     296.2338     289.3116      52.1810       0.1406       0.1902       7.6420    2627.8340      19.6775      12.1250    4482.0000
 2292.0960      85.1151     117.5529     132.1771     131.5399      94.3258      10.6016     311.0000       0.0475       0.0129    -999.2500      87.3655     296.0517     290.5388      52.1810       0.1305       0.1796       7.6617    2628.7659      19.5789      12.1250    4412.0000
 2292.2484      59.0879     128.4113     137.6772     169.5350      68.3327      14.6343     311.0000       0.0463       0.0116    -999.2500      87.3655     296.0517     284.5910      52.1810       0.1290       0.1780       7.6487    2630.8855      19.7992      12.1250    4498.0000
 2292.4008      64.3315      83.2645     127.9591     115.2210     117.2084       8.5318     311.0000       0.0456       0.0109    -999.2500      87.3655     296.0517     281.7624      52.1810       0.1544       0.2048       7.6436    2631.9429      19.8987      12.1250    4517.0000
 2292.5532      39.1599      51.6885      62.1350      94.3230      75.0993      13.3157     311.0000       0.0474       0.0127    -999.2500      87.3655     296.5980     281.8811      52.1810       0.1455       0.1955       7.6659    2628.9629      19.3378      12.0000    4582.0000
 2292.7056      29.1469      26.7103      28.9349      39.4670      39.2114      25.5028     311.0000       0.0479       0.0133    -999.2500      87.3655     296.0517     287.2479      52.1810       0.1407       0.1904       7.7244    2628.1177      19.6424      10.2500    4583.0000
 2292.8580      51.9300      29.4885      39.0578      43.2532      49.2425      20.3077     311.0000       0.0409       0.0060    -999.2500      87.3655     296.0517     295.8782      52.1810       0.1461       0.1961       7.7782    2640.1448      20.4250       9.3125    4517.0000
 2293.0104      74.6548      67.3719      82.8265      99.9020      95.8603      10.4318     311.0000       0.0316      -0.0036    -999.2500      87.3655     296.0517     304.9142      52.1810       0.1461       0.1961       7.7966    2655.9697      21.9682       9.3125    4429.0000
 2293.1628      99.3921      98.2109      86.6780      94.7432      99.5976      10.0404     311.0000       0.0261      -0.0093    -999.2500      87.3655     296.0517     318.4643      52.1810       0.1461       0.1961       7.8000    2665.3213      22.6960       8.5000    4516.0000
 2293.3152      51.2876      63.0195     110.8936     118.7260     106.7546       9.3673     311.0000       0.0255      -0.0100    -999.2500      87.3655     296.0517     329.4992      52.1810       0.1461       0.1961       7.7982    2666.4370      23.4494       8.1875    4420.0000
 2293.4676      37.5699      47.2836      80.8548      83.3397      74.4378      13.4340     311.0000       0.0293      -0.0060    -999.2500      87.3655     296.3248     332.7770      52.1810       0.1461       0.1961       7.8052    2659.9294      24.2744       6.8750    4443.0000
 2293.6200      35.5518      50.9968      89.5562     100.7357      64.2212      15.5712     311.0000       0.0320      -0.0032    -999.2500      87.3655     296.0517     326.5548      52.1810       0.1461       0.1961       7.8200    2655.3210      24.8868       4.0000    4549.0000
 2293.7724      29.7260      54.1075      95.1000     112.3719      58.5396      17.0824     311.0000       0.0324      -0.0028    -999.2500      87.3655     296.3248     321.9292      52.1810       0.1461       0.1961       7.8591    2654.5400      25.1824       2.3750    4538.0000
 2293.9248      25.7482      67.1566      98.6477     105.2093      43.3288      23.0794     311.0000       0.0277      -0.0076    -999.2500      87.3655     296.2338     322.4082      52.1810       0.1461       0.1961       7.9122    2662.6028      24.9604       2.3750    4466.0000
 2294.0772      23.2916      66.3941     103.1570      93.6075      43.0862      23.2093     311.0000       0.0236      -0.0119    -999.2500      87.3655     296.3248     324.4400      52.1810       0.1461       0.1961       7.9666    2669.5588      24.7461       1.6875    4517.0000
 2294.2296      20.5704     100.4060     164.6548     151.3322      49.6751      20.1308     311.0000       0.0248      -0.0107    -999.2500      87.3655     296.0517     321.8212      52.1810       0.1461       0.1961       8.0079    2667.6633      24.5159       0.3125    4459.0000
 2294.3820      18.5524     204.6147     187.4152     199.6295      59.6152      16.7742     311.0000       0.0312      -0.0040    -999.2500      87.3655     296.5980     315.7926      52.1810       0.1461       0.1961       8.0446    2656.5972      24.3435      -1.8750    4543.0000
 2294.5344      18.0069     313.9319     200.4602     277.0433      91.5492      10.9231     311.0000       0.0372       0.0022    -999.2500      87.3655     296.3248     306.7484      52.1810       0.1461       0.1961       8.0794    2646.4131      24.1321      -6.8750    4485.0000
 2294.6868      16.4908     229.1333     216.0000     407.4684     164.0004       6.0975     311.0000       0.0435       0.0087    -999.2500      87.3655     296.2338     295.8684      52.1810       0.1461       0.1961       8.1168    2635.6372      23.7064      -7.3750    4494.0000
 2294.8392      15.4148     100.9616     121.7614     462.0410      81.2066      12.3143     311.0000       0.0558       0.0214    -999.2500      87.3655     296.4159     281.5297      52.1810       0.1461       0.1961       8.1626    2614.6501      24.0256     -12.1250    4630.0000
 2294.9916      14.2624      51.1587      55.1975     345.2289      77.4213      12.9163     311.0000       0.0810       0.0476    -999.2500      87.3655     295.8696     263.1495      52.1810       0.1461       0.1961       8.2124    2571.5383      25.3435     -17.1250    4617.0000
 2295.1440      12.5719      58.9649      61.4514     639.6445     203.2627       4.9197     311.0000       0.1185       0.0865    -999.2500      87.3655     234.3181     240.4261      52.1810       0.1479       0.1980       8.2708    2507.2886      18.4660     -17.1250    4470.0000
 2295.2964      11.1838      78.3546     129.6932     809.4730     278.5286       3.5903     311.0000       0.1435       0.1123    -999.2500      87.3655     136.7098     233.1042      52.1810       0.1520       0.2023       8.3352    2464.6846      13.4011     -17.8125    4517.0000
 2295.4488       9.8919      82.6206     182.7271    1196.7682     535.9200       1.8660     311.0000       0.1530       0.1222    -999.2500      87.3655     105.3878     236.1562      52.1810       0.1530       0.2033       8.4111    2448.4417      10.2536     -19.7500    4475.0000
 2295.6012       8.8262      91.9996     166.6693    1339.3188     676.9203       1.4773     311.0000       0.1456       0.1145    -999.2500      87.3655     105.3878     247.5970      52.1810       0.1530       0.2033       8.4818    2461.0601       8.7786     -20.0000    4483.0000
 2295.7536       8.0160      62.6274     148.7994    1629.4357    1027.1549       0.9736     311.0000       0.1438       0.1126    -999.2500      87.3655     105.3878     251.3418      52.1810       0.1530       0.2033       8.5406    2464.1572       8.5517     -19.6250    4487.0000
 2295.9060       7.4885      54.5421     148.2662    1834.8358    1322.5742       0.7561     311.0000       0.1445       0.1134    -999.2500      87.3655     105.3878     253.9473      52.1810       0.1530       0.2033       8.5675    2462.8660       9.1784     -18.0625    4493.0000
 2296.0584       7.1808      47.1538     151.7106    1950.0000    1337.7976       0.7475     311.0000       0.1452       0.1141    -999.2500      87.3655     105.3878     257.8771      52.1810       0.1530       0.2033       8.5591    2461.7837      10.4381     -17.1250    4468.0000
 2296.2108       7.0232      43.3991     148.6968    1950.0000    1086.7915       0.9201     311.0000       0.1438       0.1126    -999.2500      87.3655     105.3878     261.8818      52.1810       0.1530       0.2033       8.5305    2464.1458      10.8110     -16.5625    4450.0000
 2296.3632       6.9502      41.6601     144.9273    1950.0000     804.9551       1.2423     311.0000       0.1412       0.1099    -999.2500      87.3655     105.3878     266.3073      52.1810       0.1530       0.2033       8.5091    2468.6055      11.1931     -14.8125    4483.0000
 2296.5156       6.9289      41.3295     141.2746    1950.0000     605.2917       1.6521     311.0000       0.1400       0.1087    -999.2500      87.3655     105.3878     268.3146      52.1810       0.1530       0.2033       8.5039    2470.6160      11.9298      -8.9375    4525.0000
 2296.6680       6.9401      42.0072     139.6145    1950.0000     462.6004       2.1617     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4980      52.1810       0.1530       0.2033       8.5040    2470.7991      12.6178      -7.4375    4563.0000
 2296.8204       6.9769      43.5089     141.5195    1950.0000     383.9679       2.6044     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.5034      52.1810       0.1530       0.2033       8.5041    2470.8042      12.5274      -2.8125    4548.0000
 2296.9728       7.0206      45.7633     146.3803    1950.0000     339.1072       2.9489     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4965      52.1810       0.1530       0.2033       8.5040    2470.7969      12.0871      -1.3125    4422.0000
 2297.1252       7.0518      47.4736     150.4512    1950.0000     304.7217       3.2817     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4879      52.1810       0.1530       0.2033       8.5038    2470.7881      10.8194      -0.6875    4372.0000
 2297.2776       7.0632      48.1924     152.1475    1950.0000     277.1580       3.6081     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4791      52.1810       0.1530       0.2033       8.5036    2470.7793       9.5037      -1.4375    4287.0000
 2297.4300       7.0609      48.0707     153.7203    1950.0000     259.4638       3.8541     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4698      52.1810       0.1530       0.2033       8.5034    2470.7693       8.3863      -1.0000    4090.0000
 2297.5824       7.0406      47.3977     153.2262    1950.0000     246.6871       4.0537     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4608      52.1810       0.1530       0.2033       8.5031    2470.7590       8.0821      -0.4375    4101.0000
 2297.7348       7.0355      46.3211     152.9497    1950.0000     237.2637       4.2147     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4531      52.1810       0.1530       0.2033       8.5028    2470.7493       8.0657      -1.1875    4021.0000
 2297.8872       7.0247      45.3294     150.3409    1950.0000     225.7405       4.4299     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4531      52.1810       0.1530       0.2033       8.5024    2470.7451       8.0603      -1.0625    3921.0000
 2298.0396       7.0326      45.6303     152.4621    1950.0000     228.6479       4.3735     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.4741      52.1810       0.1530       0.2033       8.5020    2470.7585       8.0572      -0.6875    3850.0000
 2298.1920       7.0518      46.2559     153.6393    1950.0000     234.5394       4.2637     311.0000       0.1399       0.1086    -999.2500      87.3655     105.3878     268.5232      52.1810       0.1530       0.2033       8.5014    2470.7881       8.0555       0.3125    3708.0000
 2298.3444       7.0558      47.0604     156.1631    1950.0000     240.7619       4.1535     311.0000       0.1398       0.1085    -999.2500      87.3655     105.3878     268.7562      52.1810       0.1530       0.2033       8.5010    2471.0034       8.0545      -0.1875    3657.0000
 2298.4968       7.0783      46.4826     154.5935    1950.0000     245.9419       4.0660     311.0000       0.1395       0.1082    -999.2500      87.3655     105.3878     269.2070      52.1810       0.1530       0.2033       8.5006    2471.4480       8.0537       1.0625    3588.0000
 2298.6492       7.0989      46.2175     153.9033    1950.0000     254.6467       3.9270     311.0000       0.1391       0.1078    -999.2500      87.3655     105.3878     269.8033      52.1810       0.1530       0.2033       8.4991    2472.0693       8.0531       0.3125    3434.0000
 2298.8016       7.1136      45.7323     154.7850    1950.0000     273.8656       3.6514     311.0000       0.1360       0.1046    -999.2500      87.3655     105.3878     275.0728      52.1810       0.1530       0.2033       8.4993    2477.3684       8.0525       0.7500    3320.0000
 2298.9540       7.1239      45.0395     153.9312    1950.0000     289.9550       3.4488     311.0000       0.1331       0.1016    -999.2500      87.3655     105.3878     280.0610      52.1810       0.1530       0.2033       8.4970    2482.3794       8.0519      -0.3125    3264.0000
 2299.1064       7.1292      44.9754     151.5845    1950.0000     315.9265       3.1653     311.0000       0.1303       0.0987    -999.2500      87.3655     105.3878     284.8294      52.1810       0.1530       0.2033       8.4929    2487.1526       8.0510      -1.3125    3168.0000
 2299.2588       7.1630      44.1552     150.0509    1950.0000     343.1187       2.9144     311.0000       0.1304       0.0988    -999.2500      87.3655     105.3878     284.6808      52.1810       0.1530       0.2033       8.4833    2487.0046       8.0501      -1.8125    3099.0000
 2299.4112       7.1518      43.0393     144.1564    1950.0000     359.4189       2.7823     311.0000       0.1305       0.0989    -999.2500      87.3655     105.3878     284.5178      52.1810       0.1530       0.2033       8.4726    2486.8420       8.0494      -0.7500    2999.0000
 2299.5636       7.1598      43.6681     139.3387    1950.0000     368.3640       2.7147     311.0000       0.1306       0.0990    -999.2500      87.3655     105.3878     284.3366      52.1810       0.1530       0.2033       8.4607    2486.6626       8.0491      -2.0625    2904.0000
 2299.7160       7.2126      45.8575     140.9195    1950.0000     396.1451       2.5243     311.0000       0.1307       0.0991    -999.2500      87.3655     105.3878     284.1313      52.1810       0.1530       0.2033       8.4474    2486.4602       8.0495       2.3750    2859.0000
 2299.8684       7.2825      49.1665     143.2915    1950.0000     402.2893       2.4858     311.0000       0.1309       0.0993    -999.2500      87.3655     105.3878     283.8986      52.1810       0.1530       0.2033       8.4329    2486.2341       8.0507       2.3750    2869.0000
 2300.0208       7.2560      48.1847     135.4647    1950.0000     384.6496       2.5998     311.0000       0.1310       0.0994    -999.2500      87.3655     105.3878     283.6137      52.1810       0.1530       0.2033       8.4166    2485.9639       8.0524      -0.6875    2855.0000
 2300.1732       7.2271      47.8532     127.1694    1950.0000     388.7758       2.5722     311.0000       0.1312       0.0996    -999.2500      87.3655     105.3878     283.2389      52.1810       0.1530       0.2033       8.3985    2485.6187       8.0542       2.3750    2787.0000
 2300.3256       7.2186      45.8433     124.5982    1950.0000     379.3490       2.6361     311.0000       0.1315       0.0999    -999.2500      87.3655     105.3878     282.7442      52.1810       0.1530       0.2033       8.3793    2485.1853       8.0556       0.3125    2796.0000
 2300.4780       7.2431      45.2938     121.1260    1950.0000     401.6699       2.4896     311.0000       0.1319       0.1004    -999.2500      87.3655     105.3878     281.8334      52.1810       0.1530       0.2033       8.3549    2484.4011       8.0566      -2.5000    2794.0000
 2300.6304       7.2572      44.6435     123.4066    1950.0000     421.6946       2.3714     311.0000       0.1327       0.1011    -999.2500      87.3655     105.3878     280.3311      52.1810       0.1530       0.2033       8.3319    2483.1567       8.0575      -0.6250    2803.0000
 2300.7828       7.2656      44.5445     123.3301    1950.0000     449.6612       2.2239     311.0000       0.1339       0.1024    -999.2500      87.3655     105.3878     277.6465      52.1810       0.1530       0.2033       8.3070    2481.0154       8.0583       1.0625    2835.0000
 2300.9352       7.2646      44.3547     123.6185    1950.0000     472.9831       2.1142     311.0000       0.1374       0.1060    -999.2500      87.3655     105.3878     270.4151      52.1810       0.1530       0.2033       8.2421    2475.0642       8.0588       2.3750    2824.0000
 2301.0876       7.2645      44.2988     124.7574    1950.0000     488.2502       2.0481     311.0000       0.1439       0.1128    -999.2500      87.3655     105.3878     789.8561      52.1810       0.1530       0.2033       8.2460    2463.9431       8.0595       2.3750    2771.0000
 2301.2400       7.2646      44.3732     125.5471    1950.0000     496.5199       2.0140     311.0000       0.1544       0.1237    -999.2500      87.3655     105.3878    1569.2122      52.1810       0.1530       0.2033       8.1813    2445.9124       8.0609      -0.6250    2782.0000
 2301.3924       7.2649      44.5467     126.0879    1950.0000     500.6500       1.9974     311.0000       0.1686       0.1384    -999.2500      87.3655     105.3878    2343.1455      52.1810       0.1530       0.2033       7.7591    2421.6479       8.0638      -0.1250    2717.0000
 2301.5448       7.2649      44.6943     126.7988    1950.0000     501.9844       1.9921     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.0687       0.3125    2611.0000
 2301.6972       7.2653      44.9282     127.7477    1950.0000     505.8957       1.9767     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.0766       1.1250    2559.0000
 2301.8496       7.2643      44.6365     127.1743    1950.0000     501.9818       1.9921     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.0880      -0.3125    2505.0000
 2302.0020       7.2594      44.3081     126.1843    1950.0000     495.3103       2.0189     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.1000       2.3750    2384.0000
 2302.1544       7.2552      44.2993     126.2147    1950.0000     494.2253       2.0234     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.1190       2.3750    2339.0000
 2302.3068       7.2553      44.4639     127.1992    1950.0000     495.9609       2.0163     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.2249       0.2500    2146.0000
 2302.4592       7.2568      44.6991     127.3363    1950.0000     492.8064       2.0292     311.0000     585.9415     607.2121    -999.2500      87.3655     105.3878 -999250.0000      52.1810       0.1530       0.2033    -999.2500 -999250.0000       8.2957       0.0000    2015.0000
